/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.Function;
import io.jsonwebtoken.impl.security.EdwardsCurve;
import io.jsonwebtoken.impl.security.EdwardsPublicKeyDeriver$ConstantRandom;
import io.jsonwebtoken.impl.security.KeysBridge;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.KeyPairBuilder;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;

final class EdwardsPublicKeyDeriver
implements Function<PrivateKey, PublicKey> {
    public static final Function<PrivateKey, PublicKey> INSTANCE = new EdwardsPublicKeyDeriver();

    private EdwardsPublicKeyDeriver() {
    }

    @Override
    public final PublicKey apply(PrivateKey object) {
        EdwardsCurve edwardsCurve = EdwardsCurve.findByKey((Key)object);
        if (edwardsCurve == null) {
            object = "Unable to derive Edwards-curve PublicKey for specified PrivateKey: " + KeysBridge.toString((Key)object);
            throw new InvalidKeyException((String)object);
        }
        object = edwardsCurve.getKeyMaterial((Key)object);
        object = new EdwardsPublicKeyDeriver$ConstantRandom((byte[])object);
        object = (KeyPair)((KeyPairBuilder)edwardsCurve.keyPair().random((SecureRandom)object)).build();
        Assert.stateNotNull(object, "Edwards curve generated keypair cannot be null.");
        return Assert.stateNotNull(((KeyPair)object).getPublic(), "Edwards curve KeyPair must have a PublicKey");
    }
}

