/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.io.Codec;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.impl.lang.Converters;
import io.jsonwebtoken.impl.security.ECCurve;
import java.math.BigInteger;

final class FieldElementConverter
implements Converter<BigInteger, byte[]> {
    static final FieldElementConverter INSTANCE = new FieldElementConverter();
    static final Converter<BigInteger, Object> B64URL_CONVERTER = Converters.forEncoded(BigInteger.class, Converters.compound(INSTANCE, Codec.BASE64URL));
    private static final int P256_BYTE_LEN = FieldElementConverter.bytelen(ECCurve.P256);
    private static final int P384_BYTE_LEN = FieldElementConverter.bytelen(ECCurve.P384);
    private static final int P521_BYTE_LEN = FieldElementConverter.bytelen(ECCurve.P521);

    FieldElementConverter() {
    }

    private static int bytelen(ECCurve eCCurve) {
        return Bytes.length(eCCurve.toParameterSpec().getCurve().getField().getFieldSize());
    }

    @Override
    public final byte[] applyTo(BigInteger object) {
        byte[] byArray = Converters.BIGINT_UBYTES.applyTo((BigInteger)object);
        object = byArray;
        int n2 = byArray.length;
        if (n2 == P256_BYTE_LEN || n2 == P384_BYTE_LEN || n2 == P521_BYTE_LEN) {
            return object;
        }
        object = n2 < P256_BYTE_LEN ? (Object)Bytes.prepad((byte[])object, P256_BYTE_LEN) : (n2 < P384_BYTE_LEN ? (Object)Bytes.prepad((byte[])object, P384_BYTE_LEN) : (Object)Bytes.prepad((byte[])object, P521_BYTE_LEN));
        return object;
    }

    @Override
    public final BigInteger applyFrom(byte[] byArray) {
        return Converters.BIGINT_UBYTES.applyFrom(byArray);
    }
}

