/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.io.Streams;
import io.jsonwebtoken.impl.security.AesAlgorithm;
import io.jsonwebtoken.impl.security.GcmAesAeadAlgorithm$1;
import io.jsonwebtoken.impl.security.GcmAesAeadAlgorithm$2;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.AeadAlgorithm;
import io.jsonwebtoken.security.AeadRequest;
import io.jsonwebtoken.security.AeadResult;
import io.jsonwebtoken.security.DecryptAeadRequest;
import io.jsonwebtoken.security.Request;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;

public class GcmAesAeadAlgorithm
extends AesAlgorithm
implements AeadAlgorithm {
    private static final String TRANSFORMATION_STRING = "AES/GCM/NoPadding";

    public GcmAesAeadAlgorithm(int n2) {
        super("A" + n2 + "GCM", TRANSFORMATION_STRING, n2);
    }

    @Override
    public void encrypt(AeadRequest object, AeadResult aeadResult) throws SecurityException {
        Assert.notNull(object, "Request cannot be null.");
        Assert.notNull(aeadResult, "Result cannot be null.");
        SecretKey secretKey = this.assertKey((SecretKey)object.getKey());
        InputStream inputStream = (InputStream)Assert.notNull(object.getPayload(), "Request content (plaintext) InputStream cannot be null.");
        OutputStream outputStream = Assert.notNull(aeadResult.getOutputStream(), "Result ciphertext OutputStream cannot be null.");
        InputStream inputStream2 = object.getAssociatedData();
        byte[] byArray = this.ensureInitializationVector((Request<?>)object);
        AlgorithmParameterSpec algorithmParameterSpec = this.getIvSpec(byArray);
        object = this.jca((Request<?>)object).withCipher(new GcmAesAeadAlgorithm$1(this, secretKey, algorithmParameterSpec, inputStream, inputStream2, outputStream));
        Streams.flush(outputStream);
        Streams.reset(inputStream);
        aeadResult.setTag((byte[])object).setIv(byArray);
    }

    @Override
    public void decrypt(DecryptAeadRequest decryptAeadRequest, OutputStream outputStream) throws SecurityException {
        Assert.notNull(decryptAeadRequest, "Request cannot be null.");
        Assert.notNull(outputStream, "Plaintext OutputStream cannot be null.");
        SecretKey secretKey = this.assertKey((SecretKey)decryptAeadRequest.getKey());
        InputStream inputStream = (InputStream)Assert.notNull(decryptAeadRequest.getPayload(), "Decryption request content (ciphertext) InputStream cannot be null.");
        InputStream inputStream2 = decryptAeadRequest.getAssociatedData();
        byte[] byArray = Assert.notEmpty(decryptAeadRequest.getDigest(), "Decryption request authentication tag cannot be null or empty.");
        Object object = this.assertDecryptionIv(decryptAeadRequest);
        object = this.getIvSpec((byte[])object);
        inputStream = new SequenceInputStream(inputStream, Streams.of(byArray));
        this.jca(decryptAeadRequest).withCipher(new GcmAesAeadAlgorithm$2(this, secretKey, (AlgorithmParameterSpec)object, inputStream, inputStream2, outputStream));
        Streams.flush(outputStream);
    }
}

