/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.io.Streams;
import io.jsonwebtoken.impl.io.TeeOutputStream;
import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.security.AesAlgorithm;
import io.jsonwebtoken.impl.security.DefaultMacAlgorithm;
import io.jsonwebtoken.impl.security.DefaultSecureRequest;
import io.jsonwebtoken.impl.security.HmacAesAeadAlgorithm$1;
import io.jsonwebtoken.impl.security.HmacAesAeadAlgorithm$2;
import io.jsonwebtoken.impl.security.RandomSecretKeyBuilder;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.AeadAlgorithm;
import io.jsonwebtoken.security.AeadRequest;
import io.jsonwebtoken.security.AeadResult;
import io.jsonwebtoken.security.DecryptAeadRequest;
import io.jsonwebtoken.security.Request;
import io.jsonwebtoken.security.SecretKeyBuilder;
import io.jsonwebtoken.security.SecureRequest;
import io.jsonwebtoken.security.SignatureException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class HmacAesAeadAlgorithm
extends AesAlgorithm
implements AeadAlgorithm {
    private static final String TRANSFORMATION_STRING = "AES/CBC/PKCS5Padding";
    private final DefaultMacAlgorithm SIGALG;

    private static int digestLength(int n2) {
        return n2 << 1;
    }

    private static String id(int n2) {
        return "A" + n2 + "CBC-HS" + HmacAesAeadAlgorithm.digestLength(n2);
    }

    public HmacAesAeadAlgorithm(String string, DefaultMacAlgorithm defaultMacAlgorithm) {
        super(string, TRANSFORMATION_STRING, defaultMacAlgorithm.getKeyBitLength());
        this.SIGALG = defaultMacAlgorithm;
    }

    public HmacAesAeadAlgorithm(int n2) {
        this(HmacAesAeadAlgorithm.id(n2), new DefaultMacAlgorithm(HmacAesAeadAlgorithm.id(n2), "HmacSHA" + HmacAesAeadAlgorithm.digestLength(n2), n2));
    }

    @Override
    public int getKeyBitLength() {
        return super.getKeyBitLength() << 1;
    }

    @Override
    public SecretKeyBuilder key() {
        return new RandomSecretKeyBuilder("AES", this.getKeyBitLength());
    }

    byte[] assertKeyBytes(SecureRequest<?, SecretKey> object) {
        object = (SecretKey)Assert.notNull(object.getKey(), "Request key cannot be null.");
        return this.validateLength((SecretKey)object, this.keyBitLength << 1, true);
    }

    @Override
    public void encrypt(AeadRequest object, AeadResult aeadResult) {
        SecretKeySpec secretKeySpec;
        Assert.notNull(object, "Request cannot be null.");
        Assert.notNull(aeadResult, "Result cannot be null.");
        Object object2 = this.assertKeyBytes((SecureRequest<?, SecretKey>)object);
        int n2 = ((byte[])object2).length / 2;
        byte[] byArray = Arrays.copyOfRange(object2, 0, n2);
        Object object3 = Arrays.copyOfRange(object2, n2, ((byte[])object2).length);
        try {
            secretKeySpec = new SecretKeySpec((byte[])object3, "AES");
        }
        finally {
            Bytes.clear(object3);
            Bytes.clear(object2);
        }
        InputStream inputStream = (InputStream)Assert.notNull(object.getPayload(), "Request content (plaintext) InputStream cannot be null.");
        object2 = Assert.notNull(aeadResult.getOutputStream(), "Result ciphertext OutputStream cannot be null.");
        object3 = object.getAssociatedData();
        byte[] byArray2 = this.ensureInitializationVector((Request<?>)object);
        AlgorithmParameterSpec algorithmParameterSpec = this.getIvSpec(byArray2);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        object2 = new TeeOutputStream((OutputStream)object2, byteArrayOutputStream);
        this.jca((Request<?>)object).withCipher(new HmacAesAeadAlgorithm$1(this, secretKeySpec, algorithmParameterSpec, inputStream, (OutputStream)object2));
        object = object3 == null ? Bytes.EMPTY : Streams.bytes((InputStream)object3, "Unable to read AAD bytes.");
        try {
            object = this.sign((byte[])object, byArray2, Streams.of(byteArrayOutputStream.toByteArray()), byArray);
            aeadResult.setTag((byte[])object).setIv(byArray2);
            return;
        }
        finally {
            Bytes.clear(byArray);
        }
    }

    private byte[] sign(byte[] object, byte[] object2, InputStream inputStream, byte[] byArray) {
        long l2 = io.jsonwebtoken.lang.Arrays.length(object);
        long l3 = l2 << 3;
        long l4 = l3 & 0xFFFFFFFFL;
        byte[] byArray2 = Bytes.toBytes(l4);
        ArrayList<InputStream> arrayList = new ArrayList<InputStream>(4);
        if (!Bytes.isEmpty(object)) {
            arrayList.add(Streams.of(object));
        }
        arrayList.add(Streams.of(object2));
        arrayList.add(inputStream);
        arrayList.add(Streams.of(byArray2));
        object = new SequenceInputStream(Collections.enumeration(arrayList));
        object2 = new SecretKeySpec(byArray, this.SIGALG.getJcaName());
        object = new DefaultSecureRequest<byte[], byte[]>((byte[])object, null, null, (byte[])object2);
        object = this.SIGALG.digest(object);
        return this.assertTag(Arrays.copyOfRange(object, 0, byArray.length));
    }

    @Override
    public void decrypt(DecryptAeadRequest decryptAeadRequest, OutputStream outputStream) {
        SecretKeySpec secretKeySpec;
        Assert.notNull(decryptAeadRequest, "Request cannot be null.");
        Assert.notNull(outputStream, "Plaintext OutputStream cannot be null.");
        Object object = this.assertKeyBytes(decryptAeadRequest);
        int n2 = ((byte[])object).length / 2;
        byte[] byArray = Arrays.copyOfRange(object, 0, n2);
        byte[] byArray2 = Arrays.copyOfRange(object, n2, ((byte[])object).length);
        try {
            secretKeySpec = new SecretKeySpec(byArray2, "AES");
        }
        finally {
            Bytes.clear(byArray2);
            Bytes.clear(object);
        }
        InputStream inputStream = (InputStream)Assert.notNull(decryptAeadRequest.getPayload(), "Decryption request content (ciphertext) InputStream cannot be null.");
        object = decryptAeadRequest.getAssociatedData();
        byArray2 = this.assertTag(decryptAeadRequest.getDigest());
        byte[] byArray3 = this.assertDecryptionIv(decryptAeadRequest);
        AlgorithmParameterSpec algorithmParameterSpec = this.getIvSpec(byArray3);
        object = object == null ? Bytes.EMPTY : Streams.bytes((InputStream)object, "Unable to read AAD bytes.");
        try {
            object = this.sign((byte[])object, byArray3, inputStream, byArray);
        }
        finally {
            Bytes.clear(byArray);
        }
        if (!MessageDigest.isEqual(object, byArray2)) {
            object = "Ciphertext decryption failed: Authentication tag verification failed.";
            throw new SignatureException((String)object);
        }
        Streams.reset(inputStream);
        object = inputStream;
        this.jca(decryptAeadRequest).withCipher(new HmacAesAeadAlgorithm$2(this, secretKeySpec, algorithmParameterSpec, (InputStream)object, outputStream));
    }
}

