/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.security.JcaTemplate$InstanceFactory;
import io.jsonwebtoken.impl.security.Providers;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.SecurityException;
import io.jsonwebtoken.security.SignatureException;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.crypto.Mac;

abstract class JcaTemplate$JcaInstanceFactory<T>
implements JcaTemplate$InstanceFactory<T> {
    private final Class<T> clazz;
    private final ConcurrentMap<String, Boolean> FALLBACK_ATTEMPTS = new ConcurrentHashMap<String, Boolean>();

    JcaTemplate$JcaInstanceFactory(Class<T> clazz) {
        this.clazz = Assert.notNull(clazz, "Class argument cannot be null.");
    }

    @Override
    public Class<T> getInstanceClass() {
        return this.clazz;
    }

    @Override
    public String getId() {
        return this.clazz.getSimpleName();
    }

    protected Provider findBouncyCastle() {
        return Providers.findBouncyCastle();
    }

    @Override
    public final T get(String string, Provider provider) throws Exception {
        Assert.hasText(string, "jcaName cannot be null or empty.");
        Provider provider2 = provider;
        Serializable serializable = (Boolean)this.FALLBACK_ATTEMPTS.get(string);
        if (provider2 == null && serializable != null && serializable.booleanValue()) {
            provider2 = this.findBouncyCastle();
        }
        try {
            return this.doGet(string, provider2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (provider == null && serializable == null && (serializable = this.findBouncyCastle()) != null) {
                try {
                    serializable = this.doGet(string, (Provider)serializable);
                    this.FALLBACK_ATTEMPTS.putIfAbsent(string, Boolean.TRUE);
                    return (T)serializable;
                }
                catch (Throwable throwable) {
                    this.FALLBACK_ATTEMPTS.putIfAbsent(string, Boolean.FALSE);
                }
            }
            throw this.wrap(noSuchAlgorithmException, string, provider, null);
        }
        catch (Exception exception) {
            throw this.wrap(exception, string, provider, null);
        }
    }

    protected abstract T doGet(String var1, Provider var2) throws Exception;

    protected Exception wrap(Exception exception, String string, Provider provider, Provider provider2) {
        string = "Unable to obtain '" + string + "' " + this.getId() + " instance from ";
        string = provider != null ? string + "specified '" + provider + "' Provider" : string + "default JCA Provider";
        if (provider2 != null) {
            string = string + " or fallback '" + provider2 + "' Provider";
        }
        string = string + ": " + exception.getMessage();
        return this.wrap(string, exception);
    }

    protected Exception wrap(String string, Exception exception) {
        if (Signature.class.isAssignableFrom(this.clazz) || Mac.class.isAssignableFrom(this.clazz)) {
            return new SignatureException(string, exception);
        }
        return new SecurityException(string, exception);
    }
}

