/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.Bytes;
import io.jsonwebtoken.impl.lang.CheckedFunction;
import io.jsonwebtoken.impl.lang.CheckedSupplier;
import io.jsonwebtoken.impl.lang.DefaultRegistry;
import io.jsonwebtoken.impl.security.EdwardsCurve;
import io.jsonwebtoken.impl.security.JcaTemplate$1;
import io.jsonwebtoken.impl.security.JcaTemplate$10;
import io.jsonwebtoken.impl.security.JcaTemplate$2;
import io.jsonwebtoken.impl.security.JcaTemplate$3;
import io.jsonwebtoken.impl.security.JcaTemplate$4;
import io.jsonwebtoken.impl.security.JcaTemplate$5;
import io.jsonwebtoken.impl.security.JcaTemplate$6;
import io.jsonwebtoken.impl.security.JcaTemplate$7;
import io.jsonwebtoken.impl.security.JcaTemplate$8;
import io.jsonwebtoken.impl.security.JcaTemplate$9;
import io.jsonwebtoken.impl.security.JcaTemplate$AlgorithmParametersFactory;
import io.jsonwebtoken.impl.security.JcaTemplate$CertificateFactoryFactory;
import io.jsonwebtoken.impl.security.JcaTemplate$CipherFactory;
import io.jsonwebtoken.impl.security.JcaTemplate$InstanceFactory;
import io.jsonwebtoken.impl.security.JcaTemplate$KeyAgreementFactory;
import io.jsonwebtoken.impl.security.JcaTemplate$KeyFactoryFactory;
import io.jsonwebtoken.impl.security.JcaTemplate$KeyGeneratorFactory;
import io.jsonwebtoken.impl.security.JcaTemplate$KeyPairGeneratorFactory;
import io.jsonwebtoken.impl.security.JcaTemplate$MacFactory;
import io.jsonwebtoken.impl.security.JcaTemplate$MessageDigestFactory;
import io.jsonwebtoken.impl.security.JcaTemplate$SecretKeyFactoryFactory;
import io.jsonwebtoken.impl.security.JcaTemplate$SignatureFactory;
import io.jsonwebtoken.impl.security.Providers;
import io.jsonwebtoken.impl.security.Randoms;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Registry;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.SecurityException;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;

public class JcaTemplate {
    private static final List<JcaTemplate$InstanceFactory<?>> FACTORIES = Collections.of(new JcaTemplate$CipherFactory(), new JcaTemplate$KeyFactoryFactory(), new JcaTemplate$SecretKeyFactoryFactory(), new JcaTemplate$KeyGeneratorFactory(), new JcaTemplate$KeyPairGeneratorFactory(), new JcaTemplate$KeyAgreementFactory(), new JcaTemplate$MessageDigestFactory(), new JcaTemplate$SignatureFactory(), new JcaTemplate$MacFactory(), new JcaTemplate$AlgorithmParametersFactory(), new JcaTemplate$CertificateFactoryFactory());
    private static final Registry<Class<?>, JcaTemplate$InstanceFactory<?>> REGISTRY = new DefaultRegistry("JCA Instance Factory", "instance class", FACTORIES, new JcaTemplate$1());
    private final String jcaName;
    private final Provider provider;
    private final SecureRandom secureRandom;

    protected Provider findBouncyCastle() {
        return Providers.findBouncyCastle();
    }

    JcaTemplate(String string) {
        this(string, null);
    }

    JcaTemplate(String string, Provider provider) {
        this(string, provider, null);
    }

    JcaTemplate(String string, Provider provider, SecureRandom secureRandom) {
        this.jcaName = Assert.hasText(string, "jcaName string cannot be null or empty.");
        this.secureRandom = secureRandom != null ? secureRandom : Randoms.secureRandom();
        this.provider = provider;
    }

    private <T, R> R execute(Class<T> clazz, CheckedFunction<T, R> checkedFunction, Provider provider) throws Exception {
        JcaTemplate$InstanceFactory jcaTemplate$InstanceFactory = (JcaTemplate$InstanceFactory)REGISTRY.get(clazz);
        Assert.notNull(jcaTemplate$InstanceFactory, "Unsupported JCA instance class.");
        provider = jcaTemplate$InstanceFactory.get(this.jcaName, provider);
        clazz = Assert.isInstanceOf(clazz, provider, "Factory instance does not match expected type.");
        return checkedFunction.apply(clazz);
    }

    private <T> T execute(Class<?> object, CheckedSupplier<T> object2) throws SecurityException {
        try {
            return object2.get();
        }
        catch (SecurityException securityException) {
            object2 = securityException;
            throw securityException;
        }
        catch (Throwable throwable) {
            object = ((Class)object).getSimpleName() + " callback execution failed: " + throwable.getMessage();
            throw new SecurityException((String)object, throwable);
        }
    }

    private <T, R> R execute(Class<T> clazz, CheckedFunction<T, R> checkedFunction) throws SecurityException {
        return (R)this.execute(clazz, new JcaTemplate$2(this, clazz, checkedFunction));
    }

    protected <T, R> R fallback(Class<T> clazz, CheckedFunction<T, R> checkedFunction) throws SecurityException {
        return (R)this.execute(clazz, new JcaTemplate$3(this, clazz, checkedFunction));
    }

    public <R> R withCipher(CheckedFunction<Cipher, R> checkedFunction) throws SecurityException {
        return this.execute(Cipher.class, checkedFunction);
    }

    public <R> R withKeyFactory(CheckedFunction<KeyFactory, R> checkedFunction) throws SecurityException {
        return this.execute(KeyFactory.class, checkedFunction);
    }

    public <R> R withSecretKeyFactory(CheckedFunction<SecretKeyFactory, R> checkedFunction) throws SecurityException {
        return this.execute(SecretKeyFactory.class, checkedFunction);
    }

    public <R> R withKeyGenerator(CheckedFunction<KeyGenerator, R> checkedFunction) throws SecurityException {
        return this.execute(KeyGenerator.class, checkedFunction);
    }

    public <R> R withKeyAgreement(CheckedFunction<KeyAgreement, R> checkedFunction) throws SecurityException {
        return this.execute(KeyAgreement.class, checkedFunction);
    }

    public <R> R withKeyPairGenerator(CheckedFunction<KeyPairGenerator, R> checkedFunction) throws SecurityException {
        return this.execute(KeyPairGenerator.class, checkedFunction);
    }

    public <R> R withMessageDigest(CheckedFunction<MessageDigest, R> checkedFunction) throws SecurityException {
        return this.execute(MessageDigest.class, checkedFunction);
    }

    public <R> R withSignature(CheckedFunction<Signature, R> checkedFunction) throws SecurityException {
        return this.execute(Signature.class, checkedFunction);
    }

    public <R> R withMac(CheckedFunction<Mac, R> checkedFunction) throws SecurityException {
        return this.execute(Mac.class, checkedFunction);
    }

    public <R> R withAlgorithmParameters(CheckedFunction<AlgorithmParameters, R> checkedFunction) throws SecurityException {
        return this.execute(AlgorithmParameters.class, checkedFunction);
    }

    public <R> R withCertificateFactory(CheckedFunction<CertificateFactory, R> checkedFunction) throws SecurityException {
        return this.execute(CertificateFactory.class, checkedFunction);
    }

    public SecretKey generateSecretKey(int n2) {
        return this.withKeyGenerator(new JcaTemplate$4(this, n2));
    }

    public KeyPair generateKeyPair() {
        return this.withKeyPairGenerator(new JcaTemplate$5(this));
    }

    public KeyPair generateKeyPair(int n2) {
        return this.withKeyPairGenerator(new JcaTemplate$6(this, n2));
    }

    public KeyPair generateKeyPair(AlgorithmParameterSpec algorithmParameterSpec) {
        return this.withKeyPairGenerator(new JcaTemplate$7(this, algorithmParameterSpec));
    }

    public PublicKey generatePublic(KeySpec keySpec) {
        return this.fallback(KeyFactory.class, new JcaTemplate$8(this, keySpec));
    }

    protected boolean isJdk11() {
        return System.getProperty("java.version").startsWith("11");
    }

    private boolean isJdk8213363Bug(InvalidKeySpecException invalidKeySpecException) {
        return this.isJdk11() && ("XDH".equals(this.jcaName) || "X25519".equals(this.jcaName) || "X448".equals(this.jcaName)) && invalidKeySpecException.getCause() instanceof InvalidKeyException && !Objects.isEmpty(invalidKeySpecException.getStackTrace()) && "sun.security.ec.XDHKeyFactory".equals(invalidKeySpecException.getStackTrace()[0].getClassName()) && "engineGeneratePrivate".equals(invalidKeySpecException.getStackTrace()[0].getMethodName());
    }

    private int getJdk8213363BugExpectedSize(InvalidKeyException object) {
        object = ((Throwable)object).getMessage();
        String string = "key length must be ";
        if (Strings.hasText((String)object) && ((String)object).startsWith(string)) {
            object = ((String)object).substring(string.length());
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1;
    }

    private KeySpec respecIfNecessary(InvalidKeySpecException generalSecurityException, KeySpec object) {
        int n2;
        if (!(object instanceof PKCS8EncodedKeySpec)) {
            return null;
        }
        object = (PKCS8EncodedKeySpec)object;
        object = ((PKCS8EncodedKeySpec)object).getEncoded();
        if (this.isJdk8213363Bug((InvalidKeySpecException)generalSecurityException) && ((n2 = this.getJdk8213363BugExpectedSize((InvalidKeyException)(generalSecurityException = Assert.isInstanceOf(InvalidKeyException.class, generalSecurityException.getCause(), "Unexpected argument.")))) == 32 || n2 == 56) && Bytes.length((byte[])object) >= n2) {
            byte[] byArray = new byte[n2];
            Object object2 = object;
            System.arraycopy(object2, ((Object)object2).length - n2, byArray, 0, n2);
            EdwardsCurve edwardsCurve = n2 == 32 ? EdwardsCurve.X25519 : EdwardsCurve.X448;
            return edwardsCurve.privateKeySpec(byArray, false);
        }
        return null;
    }

    protected PrivateKey generatePrivate(KeyFactory keyFactory, KeySpec keySpec) throws InvalidKeySpecException {
        return keyFactory.generatePrivate(keySpec);
    }

    public PrivateKey generatePrivate(KeySpec keySpec) {
        return this.fallback(KeyFactory.class, new JcaTemplate$9(this, keySpec));
    }

    public X509Certificate generateX509Certificate(byte[] byArray) {
        return this.fallback(CertificateFactory.class, new JcaTemplate$10(this, byArray));
    }

    static /* synthetic */ Provider access$000(JcaTemplate jcaTemplate) {
        return jcaTemplate.provider;
    }

    static /* synthetic */ Object access$100(JcaTemplate jcaTemplate, Class clazz, CheckedFunction checkedFunction, Provider provider) throws Exception {
        return jcaTemplate.execute(clazz, checkedFunction, provider);
    }

    static /* synthetic */ SecureRandom access$200(JcaTemplate jcaTemplate) {
        return jcaTemplate.secureRandom;
    }

    static /* synthetic */ KeySpec access$300(JcaTemplate jcaTemplate, InvalidKeySpecException invalidKeySpecException, KeySpec keySpec) {
        return jcaTemplate.respecIfNecessary(invalidKeySpecException, keySpec);
    }
}

