/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Registry;
import io.jsonwebtoken.security.Jwks$OP;
import io.jsonwebtoken.security.KeyOperation;

final class KeyOperationConverter
implements Converter<KeyOperation, Object> {
    static final Converter<KeyOperation, Object> DEFAULT = new KeyOperationConverter(Jwks$OP.get());
    private final Registry<String, KeyOperation> registry;

    KeyOperationConverter(Registry<String, KeyOperation> registry) {
        this.registry = Assert.notEmpty(registry, "KeyOperation registry cannot be null or empty.");
    }

    @Override
    public final String applyTo(KeyOperation keyOperation) {
        Assert.notNull(keyOperation, "KeyOperation cannot be null.");
        return keyOperation.getId();
    }

    @Override
    public final KeyOperation applyFrom(Object object) {
        if (object instanceof KeyOperation) {
            return (KeyOperation)object;
        }
        object = Assert.isInstanceOf(String.class, object, "Argument must be a KeyOperation or String.");
        Assert.hasText(object, "KeyOperation string value cannot be null or empty.");
        KeyOperation keyOperation = (KeyOperation)this.registry.get(object);
        if (keyOperation != null) {
            return keyOperation;
        }
        return (KeyOperation)Jwks$OP.builder().id((String)object).build();
    }
}

