/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import java.security.cert.X509Certificate;

public final class KeyUsage {
    private static final boolean[] NO_FLAGS = new boolean[9];
    private static final int digitalSignature = 0;
    private static final int nonRepudiation = 1;
    private static final int keyEncipherment = 2;
    private static final int dataEncipherment = 3;
    private static final int keyAgreement = 4;
    private static final int keyCertSign = 5;
    private static final int cRLSign = 6;
    private static final int encipherOnly = 7;
    private static final int decipherOnly = 8;
    private final boolean[] is;

    public KeyUsage(X509Certificate object) {
        object = object != null ? ((X509Certificate)object).getKeyUsage() : NO_FLAGS;
        this.is = (boolean[])(object != null ? object : (Object)NO_FLAGS);
    }

    public final boolean isDigitalSignature() {
        return this.is[0];
    }

    public final boolean isNonRepudiation() {
        return this.is[1];
    }

    public final boolean isKeyEncipherment() {
        return this.is[2];
    }

    public final boolean isDataEncipherment() {
        return this.is[3];
    }

    public final boolean isKeyAgreement() {
        return this.is[4];
    }

    public final boolean isKeyCertSign() {
        return this.is[5];
    }

    public final boolean isCRLSign() {
        return this.is[6];
    }

    public final boolean isEncipherOnly() {
        return this.is[7];
    }

    public final boolean isDecipherOnly() {
        return this.is[8];
    }
}

