/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.ParameterReadable;
import io.jsonwebtoken.impl.lang.RequiredParameterReader;
import io.jsonwebtoken.impl.security.DefaultOctetPublicJwk;
import io.jsonwebtoken.impl.security.EdwardsCurve;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.impl.security.OctetJwkFactory;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.OctetPublicJwk;
import java.security.Key;
import java.security.PublicKey;

public class OctetPublicJwkFactory
extends OctetJwkFactory<PublicKey, OctetPublicJwk<PublicKey>> {
    static final OctetPublicJwkFactory INSTANCE = new OctetPublicJwkFactory();

    OctetPublicJwkFactory() {
        super(PublicKey.class, DefaultOctetPublicJwk.PARAMS);
    }

    @Override
    protected OctetPublicJwk<PublicKey> createJwkFromKey(JwkContext<PublicKey> jwkContext) {
        Object object = Assert.notNull(jwkContext.getKey(), "PublicKey cannot be null.");
        EdwardsCurve edwardsCurve = EdwardsCurve.forKey((Key)object);
        byte[] byArray = edwardsCurve.getKeyMaterial((Key)object);
        object = byArray;
        Assert.notEmpty(byArray, "Edwards PublicKey 'x' value cannot be null or empty.");
        OctetPublicJwkFactory.put(jwkContext, DefaultOctetPublicJwk.CRV, edwardsCurve.getId());
        OctetPublicJwkFactory.put(jwkContext, DefaultOctetPublicJwk.X, object);
        return new DefaultOctetPublicJwk<PublicKey>(jwkContext);
    }

    @Override
    protected OctetPublicJwk<PublicKey> createJwkFromValues(JwkContext<PublicKey> jwkContext) {
        Object object = new RequiredParameterReader(jwkContext);
        EdwardsCurve edwardsCurve = OctetPublicJwkFactory.getCurve((ParameterReadable)object);
        object = object.get(DefaultOctetPublicJwk.X);
        object = edwardsCurve.toPublicKey((byte[])object, jwkContext.getProvider());
        jwkContext.setKey((PublicKey)object);
        return new DefaultOctetPublicJwk<PublicKey>(jwkContext);
    }
}

