/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.security.PrivateECKey;
import io.jsonwebtoken.impl.security.ProvidedKeyBuilder;
import io.jsonwebtoken.impl.security.ProviderPrivateKey;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.PrivateKeyBuilder;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECKey;

public class ProvidedPrivateKeyBuilder
extends ProvidedKeyBuilder<PrivateKey, PrivateKeyBuilder>
implements PrivateKeyBuilder {
    private PublicKey publicKey;

    ProvidedPrivateKeyBuilder(PrivateKey privateKey) {
        super(privateKey);
    }

    @Override
    public PrivateKeyBuilder publicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    @Override
    public PrivateKey doBuild() {
        PrivateKey privateKey = (PrivateKey)this.key;
        String string = Strings.clean(((PrivateKey)this.key).getAlgorithm());
        if (!(privateKey instanceof ECKey) && ("EC".equalsIgnoreCase(string) || "ECDSA".equalsIgnoreCase(string)) && this.publicKey instanceof ECKey) {
            privateKey = new PrivateECKey(privateKey, ((ECKey)((Object)this.publicKey)).getParams());
        }
        if (this.provider != null) {
            return new ProviderPrivateKey(this.provider, privateKey);
        }
        return privateKey;
    }
}

