/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.security.KeySupplier;
import java.security.Key;
import java.security.Provider;

public class ProviderKey<T extends Key>
implements KeySupplier<T>,
Key {
    private final T key;
    private final Provider provider;

    public static Provider getProvider(Key key, Provider provider) {
        if (key instanceof ProviderKey) {
            key = (ProviderKey)key;
            return Assert.stateNotNull(((ProviderKey)key).getProvider(), "ProviderKey provider can never be null.");
        }
        return provider;
    }

    public static <K extends Key> K getKey(K k2) {
        if (k2 instanceof ProviderKey) {
            return (K)((ProviderKey)k2).getKey();
        }
        return k2;
    }

    ProviderKey(Provider object, T t2) {
        this.provider = Assert.notNull(object, "Provider cannot be null.");
        this.key = (Key)Assert.notNull(t2, "Key argument cannot be null.");
        if (t2 instanceof ProviderKey) {
            object = "Nesting not permitted.";
            throw new IllegalArgumentException((String)object);
        }
    }

    @Override
    public T getKey() {
        return this.key;
    }

    @Override
    public String getAlgorithm() {
        return this.key.getAlgorithm();
    }

    @Override
    public String getFormat() {
        return this.key.getFormat();
    }

    @Override
    public byte[] getEncoded() {
        return this.key.getEncoded();
    }

    public final Provider getProvider() {
        return this.provider;
    }
}

