/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.lang.RequiredParameterReader;
import io.jsonwebtoken.impl.security.AbstractFamilyJwkFactory;
import io.jsonwebtoken.impl.security.DefaultRsaPublicJwk;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.impl.security.RsaPublicJwkFactory$1;
import io.jsonwebtoken.security.RsaPublicJwk;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;

class RsaPublicJwkFactory
extends AbstractFamilyJwkFactory<RSAPublicKey, RsaPublicJwk> {
    static final RsaPublicJwkFactory INSTANCE = new RsaPublicJwkFactory();

    RsaPublicJwkFactory() {
        super("RSA", RSAPublicKey.class, DefaultRsaPublicJwk.PARAMS);
    }

    @Override
    protected RsaPublicJwk createJwkFromKey(JwkContext<RSAPublicKey> jwkContext) {
        RSAPublicKey rSAPublicKey = jwkContext.getKey();
        jwkContext.put((RSAPublicKey)((Object)DefaultRsaPublicJwk.MODULUS.getId()), DefaultRsaPublicJwk.MODULUS.applyTo(rSAPublicKey.getModulus()));
        jwkContext.put((RSAPublicKey)((Object)DefaultRsaPublicJwk.PUBLIC_EXPONENT.getId()), DefaultRsaPublicJwk.PUBLIC_EXPONENT.applyTo(rSAPublicKey.getPublicExponent()));
        return new DefaultRsaPublicJwk(jwkContext);
    }

    @Override
    protected RsaPublicJwk createJwkFromValues(JwkContext<RSAPublicKey> jwkContext) {
        Object object = new RequiredParameterReader(jwkContext);
        BigInteger bigInteger = object.get(DefaultRsaPublicJwk.MODULUS);
        object = object.get(DefaultRsaPublicJwk.PUBLIC_EXPONENT);
        object = new RSAPublicKeySpec(bigInteger, (BigInteger)object);
        object = this.generateKey(jwkContext, new RsaPublicJwkFactory$1(this, (RSAPublicKeySpec)object));
        jwkContext.setKey((RSAPublicKey)object);
        return new DefaultRsaPublicJwk(jwkContext);
    }
}

