/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.io;

import io.jsonwebtoken.io.DecodingException;
import java.util.Arrays;

final class Base64 {
    private static final char[] BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final char[] BASE64URL_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".toCharArray();
    private static final int[] BASE64_IALPHABET = new int[256];
    private static final int[] BASE64URL_IALPHABET = new int[256];
    private static final int IALPHABET_MAX_INDEX = BASE64_IALPHABET.length - 1;
    static final Base64 DEFAULT;
    static final Base64 URL_SAFE;
    private final boolean urlsafe;
    private final char[] ALPHABET;
    private final int[] IALPHABET;

    private Base64(boolean bl2) {
        this.urlsafe = bl2;
        this.ALPHABET = bl2 ? BASE64URL_ALPHABET : BASE64_ALPHABET;
        this.IALPHABET = bl2 ? BASE64URL_IALPHABET : BASE64_IALPHABET;
    }

    private String getName() {
        if (this.urlsafe) {
            return "base64url";
        }
        return "base64";
    }

    private char[] encodeToChar(byte[] byArray, boolean bl2) {
        int n2 = byArray != null ? byArray.length : 0;
        if (n2 == 0) {
            return new char[0];
        }
        int n3 = n2 / 3 * 3;
        int n4 = n2 - n3;
        int n5 = (n2 - 1) / 3 + 1 << 2;
        n5 += bl2 ? (n5 - 1) / 76 << 1 : 0;
        int n6 = 0;
        if (n4 == 2) {
            n6 = 1;
        } else if (n4 == 1) {
            n6 = 2;
        }
        char[] cArray = new char[this.urlsafe ? n5 - n6 : n5];
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n7 < n3) {
            int n10 = (byArray[n7++] & 0xFF) << 16 | (byArray[n7++] & 0xFF) << 8 | byArray[n7++] & 0xFF;
            cArray[n8++] = this.ALPHABET[n10 >>> 18 & 0x3F];
            cArray[n8++] = this.ALPHABET[n10 >>> 12 & 0x3F];
            cArray[n8++] = this.ALPHABET[n10 >>> 6 & 0x3F];
            cArray[n8++] = this.ALPHABET[n10 & 0x3F];
            if (!bl2 || ++n9 != 19 || n8 >= n5 - 2) continue;
            cArray[n8++] = 13;
            cArray[n8++] = 10;
            n9 = 0;
        }
        if (n4 > 0) {
            n7 = (byArray[n3] & 0xFF) << 10 | (n4 == 2 ? (byArray[n2 - 1] & 0xFF) << 2 : 0);
            cArray[n5 - 4] = this.ALPHABET[n7 >> 12];
            cArray[n5 - 3] = this.ALPHABET[n7 >>> 6 & 0x3F];
            if (n4 == 2) {
                cArray[n5 - 2] = this.ALPHABET[n7 & 0x3F];
            } else if (!this.urlsafe) {
                cArray[n5 - 2] = 61;
            }
            if (!this.urlsafe) {
                cArray[n5 - 1] = 61;
            }
        }
        return cArray;
    }

    private int ctoi(char c2) {
        int n2 = c2 > IALPHABET_MAX_INDEX ? -1 : this.IALPHABET[c2];
        if (n2 < 0) {
            String string = "Illegal " + this.getName() + " character: '" + c2 + "'";
            throw new DecodingException(string);
        }
        return n2;
    }

    final byte[] decodeFast(CharSequence charSequence) throws DecodingException {
        int n2;
        int n3 = charSequence != null ? charSequence.length() : 0;
        if (n3 == 0) {
            return new byte[0];
        }
        int n4 = n3 - 1;
        for (n2 = 0; n2 < n4 && this.IALPHABET[charSequence.charAt(n2)] < 0; ++n2) {
        }
        while (n4 > 0 && this.IALPHABET[charSequence.charAt(n4)] < 0) {
            --n4;
        }
        int n5 = charSequence.charAt(n4) == '=' ? (charSequence.charAt(n4 - 1) == '=' ? 2 : 1) : 0;
        int n6 = n4 - n2 + 1;
        n3 = n3 > 76 ? (charSequence.charAt(76) == '\r' ? n6 / 78 : 0) << 1 : 0;
        n6 = ((n6 - n3) * 6 >> 3) - n5;
        byte[] byArray = new byte[n6];
        int n7 = 0;
        int n8 = 0;
        int n9 = n6 / 3 * 3;
        while (n7 < n9) {
            int n10 = this.ctoi(charSequence.charAt(n2++)) << 18 | this.ctoi(charSequence.charAt(n2++)) << 12 | this.ctoi(charSequence.charAt(n2++)) << 6 | this.ctoi(charSequence.charAt(n2++));
            byArray[n7++] = (byte)(n10 >> 16);
            byArray[n7++] = (byte)(n10 >> 8);
            byArray[n7++] = (byte)n10;
            if (n3 <= 0 || ++n8 != 19) continue;
            n2 += 2;
            n8 = 0;
        }
        if (n7 < n6) {
            n8 = 0;
            n9 = 0;
            while (n2 <= n4 - n5) {
                n8 |= this.ctoi(charSequence.charAt(n2++)) << 18 - n9 * 6;
                ++n9;
            }
            n9 = 16;
            while (n7 < n6) {
                byArray[n7++] = (byte)(n8 >> n9);
                n9 -= 8;
            }
        }
        return byArray;
    }

    final String encodeToString(byte[] byArray, boolean bl2) {
        return new String(this.encodeToChar(byArray, bl2));
    }

    static {
        Arrays.fill(BASE64_IALPHABET, -1);
        System.arraycopy(BASE64_IALPHABET, 0, BASE64URL_IALPHABET, 0, BASE64_IALPHABET.length);
        int n2 = BASE64_ALPHABET.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Base64.BASE64_IALPHABET[Base64.BASE64_ALPHABET[i2]] = i2;
            Base64.BASE64URL_IALPHABET[Base64.BASE64URL_ALPHABET[i2]] = i2;
        }
        Base64.BASE64_IALPHABET[61] = 0;
        Base64.BASE64URL_IALPHABET[61] = 0;
        DEFAULT = new Base64(false);
        URL_SAFE = new Base64(true);
    }
}

