/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.io;

import io.jsonwebtoken.io.Decoder;
import io.jsonwebtoken.io.DecodingException;
import io.jsonwebtoken.lang.Assert;

class ExceptionPropagatingDecoder<T, R>
implements Decoder<T, R> {
    private final Decoder<T, R> decoder;

    ExceptionPropagatingDecoder(Decoder<T, R> decoder) {
        Assert.notNull(decoder, "Decoder cannot be null.");
        this.decoder = decoder;
    }

    @Override
    public R decode(T object) throws DecodingException {
        Assert.notNull(object, "Decode argument cannot be null.");
        try {
            return this.decoder.decode(object);
        }
        catch (DecodingException decodingException) {
            object = decodingException;
            throw decodingException;
        }
        catch (Exception exception) {
            String string = "Unable to decode input: " + exception.getMessage();
            throw new DecodingException(string, exception);
        }
    }
}

