/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.jackson.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.jsonwebtoken.io.AbstractDeserializer;
import io.jsonwebtoken.jackson.io.JacksonDeserializer$MappedTypeDeserializer;
import io.jsonwebtoken.jackson.io.JacksonSerializer;
import io.jsonwebtoken.lang.Assert;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;

public class JacksonDeserializer<T>
extends AbstractDeserializer<T> {
    private final Class<T> returnType;
    private final ObjectMapper objectMapper;

    public JacksonDeserializer() {
        this(JacksonSerializer.DEFAULT_OBJECT_MAPPER);
    }

    public JacksonDeserializer(Map<String, Class<?>> map) {
        this(JacksonSerializer.newObjectMapper(), map);
    }

    public JacksonDeserializer(ObjectMapper objectMapper) {
        this(objectMapper, Object.class);
    }

    public JacksonDeserializer(ObjectMapper objectMapper, Map<String, Class<?>> map) {
        this(objectMapper);
        Assert.notNull(map, "Claim type map cannot be null.");
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(Object.class, new JacksonDeserializer$MappedTypeDeserializer(Collections.unmodifiableMap(map), null));
        objectMapper.registerModule(simpleModule);
    }

    private JacksonDeserializer(ObjectMapper objectMapper, Class<T> clazz) {
        Assert.notNull(objectMapper, "ObjectMapper cannot be null.");
        Assert.notNull(clazz, "Return type cannot be null.");
        this.objectMapper = objectMapper;
        this.returnType = clazz;
    }

    @Override
    protected T doDeserialize(Reader reader) throws Exception {
        return this.objectMapper.readValue(reader, this.returnType);
    }
}

