/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.lang;

import io.jsonwebtoken.lang.Arrays;
import io.jsonwebtoken.lang.Collections$EnumerationIterator;
import io.jsonwebtoken.lang.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class Collections {
    private Collections() {
    }

    public static <T> List<T> emptyList() {
        return java.util.Collections.emptyList();
    }

    public static <T> Set<T> emptySet() {
        return java.util.Collections.emptySet();
    }

    public static <K, V> Map<K, V> emptyMap() {
        return java.util.Collections.emptyMap();
    }

    @SafeVarargs
    public static <T> List<T> of(T ... TArray) {
        if (TArray == null || TArray.length == 0) {
            return java.util.Collections.emptyList();
        }
        return java.util.Collections.unmodifiableList(java.util.Arrays.asList(TArray));
    }

    public static <T> Set<T> asSet(Collection<T> collection) {
        if (Collections.isEmpty(collection)) {
            return java.util.Collections.emptySet();
        }
        return java.util.Collections.unmodifiableSet(new LinkedHashSet<T>(collection));
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... object) {
        if (object == null || ((T[])object).length == 0) {
            return java.util.Collections.emptySet();
        }
        object = new LinkedHashSet<T>(java.util.Arrays.asList(object));
        return Collections.immutable(object);
    }

    public static <K, V> Map<K, V> immutable(Map<K, V> map) {
        if (map != null) {
            return java.util.Collections.unmodifiableMap(map);
        }
        return null;
    }

    public static <T> Set<T> immutable(Set<T> set) {
        if (set != null) {
            return java.util.Collections.unmodifiableSet(set);
        }
        return null;
    }

    public static <T> List<T> immutable(List<T> list) {
        if (list != null) {
            return java.util.Collections.unmodifiableList(list);
        }
        return null;
    }

    public static <T, C extends Collection<T>> C immutable(C c2) {
        if (c2 == null) {
            return null;
        }
        if (c2 instanceof Set) {
            return (C)java.util.Collections.unmodifiableSet((Set)c2);
        }
        if (c2 instanceof List) {
            return (C)java.util.Collections.unmodifiableList((List)c2);
        }
        return (C)java.util.Collections.unmodifiableCollection(c2);
    }

    public static <T> Set<T> nullSafe(Set<T> set) {
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public static <T> Collection<T> nullSafe(Collection<T> collection) {
        if (collection == null) {
            return Collections.emptyList();
        }
        return collection;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return Collections.size(collection) == 0;
    }

    public static int size(Collection<?> collection) {
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    public static int size(Map<?, ?> map) {
        if (map == null) {
            return 0;
        }
        return map.size();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return Collections.size(map) == 0;
    }

    public static List arrayToList(Object object) {
        return java.util.Arrays.asList(Objects.toObjectArray(object));
    }

    @SafeVarargs
    public static <T> Set<T> concat(Set<T> set, T ... TArray) {
        int n2 = Math.max(1, Collections.size(set) + Arrays.length(TArray));
        LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>(n2);
        linkedHashSet.addAll(set);
        java.util.Collections.addAll(linkedHashSet, TArray);
        return Collections.immutable(linkedHashSet);
    }

    public static void mergeArrayIntoCollection(Object objectArray, Collection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Collection must not be null");
        }
        objectArray = Objects.toObjectArray(objectArray);
        java.util.Collections.addAll(collection, objectArray);
    }

    public static void mergePropertiesIntoMap(Properties properties, Map map) {
        if (map == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object = properties.getProperty(string);
                if (object == null) {
                    object = properties.get(string);
                }
                map.put(string, object);
            }
        }
    }

    public static boolean contains(Iterator iterator, Object object) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!Objects.nullSafeEquals(e2, object)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Enumeration enumeration, Object object) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object e2 = enumeration.nextElement();
                if (!Objects.nullSafeEquals(e2, object)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsInstance(Collection object, Object object2) {
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                Object e2 = object.next();
                if (e2 != object2) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(Collection collection, Collection object) {
        if (Collections.isEmpty(collection) || Collections.isEmpty(object)) {
            return false;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (!collection.contains(e2)) continue;
            return true;
        }
        return false;
    }

    public static Object findFirstMatch(Collection collection, Collection object) {
        if (Collections.isEmpty(collection) || Collections.isEmpty(object)) {
            return null;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (!collection.contains(e2)) continue;
            return e2;
        }
        return null;
    }

    public static <T> T findValueOfType(Collection<?> object, Class<T> clazz) {
        if (Collections.isEmpty(object)) {
            return null;
        }
        T t2 = null;
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (clazz != null && !clazz.isInstance(e2)) continue;
            if (t2 != null) {
                return null;
            }
            t2 = (T)e2;
        }
        return t2;
    }

    public static Object findValueOfType(Collection<?> collection, Class<?>[] classArray) {
        if (Collections.isEmpty(collection) || Objects.isEmpty(classArray)) {
            return null;
        }
        for (Class<?> clazz : classArray) {
            if ((clazz = Collections.findValueOfType(collection, clazz)) == null) continue;
            return clazz;
        }
        return null;
    }

    public static boolean hasUniqueObject(Collection object) {
        if (Collections.isEmpty(object)) {
            return false;
        }
        boolean bl2 = false;
        Object var2_2 = null;
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (!bl2) {
                bl2 = true;
                var2_2 = e2;
                continue;
            }
            if (var2_2 == e2) continue;
            return false;
        }
        return true;
    }

    public static Class<?> findCommonElementType(Collection object) {
        if (Collections.isEmpty(object)) {
            return null;
        }
        Class<?> clazz = null;
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            if (e2 == null) continue;
            if (clazz == null) {
                clazz = e2.getClass();
                continue;
            }
            if (clazz == e2.getClass()) continue;
            return null;
        }
        return clazz;
    }

    public static <A, E extends A> A[] toArray(Enumeration<E> enumeration, A[] AArray) {
        ArrayList<E> arrayList = new ArrayList<E>();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList.toArray(AArray);
    }

    public static <E> Iterator<E> toIterator(Enumeration<E> enumeration) {
        return new Collections$EnumerationIterator<E>(enumeration);
    }
}

