/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.lang;

import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.DateFormats$1;
import io.jsonwebtoken.lang.DateFormats$2;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public final class DateFormats {
    private static final String ISO_8601_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String ISO_8601_MILLIS_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final ThreadLocal<DateFormat> ISO_8601 = new DateFormats$1();
    private static final ThreadLocal<DateFormat> ISO_8601_MILLIS = new DateFormats$2();

    private DateFormats() {
    }

    public static String formatIso8601(Date date) {
        return DateFormats.formatIso8601(date, true);
    }

    public static String formatIso8601(Date date, boolean bl2) {
        if (bl2) {
            return ISO_8601_MILLIS.get().format(date);
        }
        return ISO_8601.get().format(date);
    }

    public static Date parseIso8601Date(String string) throws ParseException {
        Assert.notNull(string, "String argument cannot be null.");
        if (string.lastIndexOf(46) >= 0) {
            return ISO_8601_MILLIS.get().parse(string);
        }
        return ISO_8601.get().parse(string);
    }
}

