/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.security;

import io.jsonwebtoken.lang.Classes;
import io.jsonwebtoken.lang.Supplier;
import io.jsonwebtoken.security.DynamicJwkBuilder;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.JwkParserBuilder;
import io.jsonwebtoken.security.JwkSetBuilder;
import io.jsonwebtoken.security.JwkSetParserBuilder;
import io.jsonwebtoken.security.PublicJwk;

public final class Jwks {
    private static final String JWKS_BRIDGE_FQCN = "io.jsonwebtoken.impl.security.JwksBridge";
    private static final Supplier<DynamicJwkBuilder<?, ?>> BUILDER_SUPPLIER = (Supplier)Classes.newInstance("io.jsonwebtoken.impl.security.DefaultDynamicJwkBuilder$Supplier");
    private static final Supplier<JwkParserBuilder> PARSER_BUILDER_SUPPLIER = (Supplier)Classes.newInstance("io.jsonwebtoken.impl.security.DefaultJwkParserBuilder$Supplier");
    private static final Supplier<JwkSetBuilder> SET_BUILDER_SUPPLIER = (Supplier)Classes.newInstance("io.jsonwebtoken.impl.security.DefaultJwkSetBuilder$Supplier");
    private static final Supplier<JwkSetParserBuilder> SET_PARSER_BUILDER_SUPPLIER = (Supplier)Classes.newInstance("io.jsonwebtoken.impl.security.DefaultJwkSetParserBuilder$Supplier");

    private Jwks() {
    }

    public static DynamicJwkBuilder<?, ?> builder() {
        return BUILDER_SUPPLIER.get();
    }

    public static JwkParserBuilder parser() {
        return PARSER_BUILDER_SUPPLIER.get();
    }

    public static JwkSetBuilder set() {
        return SET_BUILDER_SUPPLIER.get();
    }

    public static JwkSetParserBuilder setParser() {
        return SET_PARSER_BUILDER_SUPPLIER.get();
    }

    public static String json(PublicJwk<?> publicJwk) {
        return Jwks.UNSAFE_JSON(publicJwk);
    }

    public static String UNSAFE_JSON(Jwk<?> jwk) {
        return (String)Classes.invokeStatic(JWKS_BRIDGE_FQCN, "UNSAFE_JSON", new Class[]{Jwk.class}, jwk);
    }
}

