/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.MimeType;
import jakarta.activation.MimeTypeParseException;

public class ActivationDataFlavor {
    private String mimeType = null;
    private MimeType mimeObject = null;
    private String humanPresentableName = null;
    private Class representationClass = null;

    public ActivationDataFlavor(Class clazz, String string, String string2) {
        this.mimeType = string;
        this.humanPresentableName = string2;
        this.representationClass = clazz;
    }

    public ActivationDataFlavor(Class clazz, String string) {
        this.mimeType = "application/x-java-serialized-object";
        this.representationClass = clazz;
        this.humanPresentableName = string;
    }

    public ActivationDataFlavor(String string, String string2) {
        this.mimeType = string;
        try {
            this.representationClass = Class.forName("java.io.InputStream");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        this.humanPresentableName = string2;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Class getRepresentationClass() {
        return this.representationClass;
    }

    public String getHumanPresentableName() {
        return this.humanPresentableName;
    }

    public void setHumanPresentableName(String string) {
        this.humanPresentableName = string;
    }

    public boolean equals(ActivationDataFlavor activationDataFlavor) {
        return this.isMimeTypeEqual(activationDataFlavor.mimeType) && activationDataFlavor.getRepresentationClass() == this.representationClass;
    }

    public boolean equals(Object object) {
        return object instanceof ActivationDataFlavor && this.equals((ActivationDataFlavor)object);
    }

    @Deprecated
    public boolean equals(String string) {
        if (string == null || this.mimeType == null) {
            return false;
        }
        return this.isMimeTypeEqual(string);
    }

    public int hashCode() {
        int n2 = 0;
        if (this.representationClass != null) {
            n2 = 0 + this.representationClass.hashCode();
        }
        return n2;
    }

    public boolean isMimeTypeEqual(String string) {
        MimeType mimeType;
        try {
            if (this.mimeObject == null) {
                this.mimeObject = new MimeType(this.mimeType);
            }
            mimeType = new MimeType(string);
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            return this.mimeType.equalsIgnoreCase(string);
        }
        return this.mimeObject.match(mimeType);
    }

    @Deprecated
    protected String normalizeMimeTypeParameter(String string, String string2) {
        return string2;
    }

    @Deprecated
    protected String normalizeMimeType(String string) {
        return string;
    }
}

