/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.ActivationDataFlavor;
import jakarta.activation.CommandInfo;
import jakarta.activation.CommandMap;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataContentHandlerFactory;
import jakarta.activation.DataHandler$1;
import jakarta.activation.DataHandlerDataSource;
import jakarta.activation.DataSource;
import jakarta.activation.DataSourceDataContentHandler;
import jakarta.activation.MimeType;
import jakarta.activation.MimeTypeParseException;
import jakarta.activation.ObjectDataContentHandler;
import jakarta.activation.SecuritySupport;
import jakarta.activation.URLDataSource;
import jakarta.activation.UnsupportedDataTypeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;

public class DataHandler {
    private DataSource dataSource = null;
    private DataSource objDataSource = null;
    private Object object = null;
    private String objectMimeType = null;
    private CommandMap currentCommandMap = null;
    private static final ActivationDataFlavor[] emptyFlavors = new ActivationDataFlavor[0];
    private ActivationDataFlavor[] transferFlavors = emptyFlavors;
    private DataContentHandler dataContentHandler = null;
    private DataContentHandler factoryDCH = null;
    private static DataContentHandlerFactory factory = null;
    private DataContentHandlerFactory oldFactory = null;
    private String shortType = null;

    public DataHandler(DataSource dataSource) {
        this.dataSource = dataSource;
        this.oldFactory = factory;
    }

    public DataHandler(Object object, String string) {
        this.object = object;
        this.objectMimeType = string;
        this.oldFactory = factory;
    }

    public DataHandler(URL uRL) {
        this.dataSource = new URLDataSource(uRL);
        this.oldFactory = factory;
    }

    private synchronized CommandMap getCommandMap() {
        if (this.currentCommandMap != null) {
            return this.currentCommandMap;
        }
        return CommandMap.getDefaultCommandMap();
    }

    public DataSource getDataSource() {
        if (this.dataSource == null) {
            if (this.objDataSource == null) {
                this.objDataSource = new DataHandlerDataSource(this);
            }
            return this.objDataSource;
        }
        return this.dataSource;
    }

    public String getName() {
        if (this.dataSource != null) {
            return this.dataSource.getName();
        }
        return null;
    }

    public String getContentType() {
        if (this.dataSource != null) {
            return this.dataSource.getContentType();
        }
        return this.objectMimeType;
    }

    public InputStream getInputStream() throws IOException {
        Object object;
        if (this.dataSource != null) {
            object = this.dataSource.getInputStream();
        } else {
            object = this.getDataContentHandler();
            if (object == null) {
                throw new UnsupportedDataTypeException("no DCH for MIME type " + this.getBaseType());
            }
            if (object instanceof ObjectDataContentHandler && ((ObjectDataContentHandler)object).getDCH() == null) {
                throw new UnsupportedDataTypeException("no object DCH for MIME type " + this.getBaseType());
            }
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
            new Thread((Runnable)new DataHandler$1(this, (DataContentHandler)object, pipedOutputStream), "DataHandler.getInputStream").start();
            object = pipedInputStream;
        }
        return object;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (this.dataSource != null) {
            byte[] byArray = new byte[8192];
            try (InputStream inputStream = this.dataSource.getInputStream();){
                int n2;
                while ((n2 = inputStream.read(byArray)) > 0) {
                    outputStream.write(byArray, 0, n2);
                }
            }
        } else {
            DataContentHandler dataContentHandler = this.getDataContentHandler();
            dataContentHandler.writeTo(this.object, this.objectMimeType, outputStream);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.dataSource != null) {
            return this.dataSource.getOutputStream();
        }
        return null;
    }

    public synchronized ActivationDataFlavor[] getTransferDataFlavors() {
        if (factory != this.oldFactory) {
            this.transferFlavors = emptyFlavors;
        }
        if (this.transferFlavors == emptyFlavors) {
            this.transferFlavors = this.getDataContentHandler().getTransferDataFlavors();
        }
        if (this.transferFlavors == emptyFlavors) {
            return this.transferFlavors;
        }
        return (ActivationDataFlavor[])this.transferFlavors.clone();
    }

    public boolean isDataFlavorSupported(ActivationDataFlavor activationDataFlavor) {
        ActivationDataFlavor[] activationDataFlavorArray = this.getTransferDataFlavors();
        for (int i2 = 0; i2 < activationDataFlavorArray.length; ++i2) {
            if (!activationDataFlavorArray[i2].equals(activationDataFlavor)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(ActivationDataFlavor activationDataFlavor) throws IOException {
        return this.getDataContentHandler().getTransferData(activationDataFlavor, this.dataSource);
    }

    public synchronized void setCommandMap(CommandMap commandMap) {
        if (commandMap != this.currentCommandMap || commandMap == null) {
            this.transferFlavors = emptyFlavors;
            this.dataContentHandler = null;
            this.currentCommandMap = commandMap;
        }
    }

    public CommandInfo[] getPreferredCommands() {
        if (this.dataSource != null) {
            return this.getCommandMap().getPreferredCommands(this.getBaseType(), this.dataSource);
        }
        return this.getCommandMap().getPreferredCommands(this.getBaseType());
    }

    public CommandInfo[] getAllCommands() {
        if (this.dataSource != null) {
            return this.getCommandMap().getAllCommands(this.getBaseType(), this.dataSource);
        }
        return this.getCommandMap().getAllCommands(this.getBaseType());
    }

    public CommandInfo getCommand(String string) {
        if (this.dataSource != null) {
            return this.getCommandMap().getCommand(this.getBaseType(), string, this.dataSource);
        }
        return this.getCommandMap().getCommand(this.getBaseType(), string);
    }

    public Object getContent() throws IOException {
        if (this.object != null) {
            return this.object;
        }
        return this.getDataContentHandler().getContent(this.getDataSource());
    }

    public Object getBean(CommandInfo commandInfo) {
        Object object = null;
        try {
            ClassLoader classLoader = SecuritySupport.getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            object = commandInfo.getCommandObject(this, classLoader);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return object;
    }

    private synchronized DataContentHandler getDataContentHandler() {
        if (factory != this.oldFactory) {
            this.oldFactory = factory;
            this.factoryDCH = null;
            this.dataContentHandler = null;
            this.transferFlavors = emptyFlavors;
        }
        if (this.dataContentHandler != null) {
            return this.dataContentHandler;
        }
        String string = this.getBaseType();
        if (this.factoryDCH == null && factory != null) {
            this.factoryDCH = factory.createDataContentHandler(string);
        }
        if (this.factoryDCH != null) {
            this.dataContentHandler = this.factoryDCH;
        }
        if (this.dataContentHandler == null) {
            this.dataContentHandler = this.dataSource != null ? this.getCommandMap().createDataContentHandler(string, this.dataSource) : this.getCommandMap().createDataContentHandler(string);
        }
        this.dataContentHandler = this.dataSource != null ? new DataSourceDataContentHandler(this.dataContentHandler, this.dataSource) : new ObjectDataContentHandler(this.dataContentHandler, this.object, this.objectMimeType);
        return this.dataContentHandler;
    }

    private synchronized String getBaseType() {
        if (this.shortType == null) {
            String string = this.getContentType();
            try {
                MimeType mimeType = new MimeType(string);
                this.shortType = mimeType.getBaseType();
            }
            catch (MimeTypeParseException mimeTypeParseException) {
                this.shortType = string;
            }
        }
        return this.shortType;
    }

    public static synchronized void setDataContentHandlerFactory(DataContentHandlerFactory dataContentHandlerFactory) {
        block4: {
            if (factory != null) {
                throw new Error("DataContentHandlerFactory already defined");
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkSetFactory();
                }
                catch (SecurityException securityException) {
                    if (DataHandler.class.getClassLoader() == dataContentHandlerFactory.getClass().getClassLoader()) break block4;
                    throw securityException;
                }
            }
        }
        factory = dataContentHandlerFactory;
    }

    static /* synthetic */ Object access$000(DataHandler dataHandler) {
        return dataHandler.object;
    }

    static /* synthetic */ String access$100(DataHandler dataHandler) {
        return dataHandler.objectMimeType;
    }
}

