/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.FactoryFinder$1;
import jakarta.activation.FactoryFinder$2;
import jakarta.activation.FactoryFinder$3;
import jakarta.activation.ServiceLoaderUtil;
import jakarta.activation.ServiceLoaderUtil$ExceptionHandler;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

class FactoryFinder {
    private static final Logger logger = Logger.getLogger("jakarta.activation");
    private static final ServiceLoaderUtil$ExceptionHandler<RuntimeException> EXCEPTION_HANDLER = new FactoryFinder$1();

    FactoryFinder() {
    }

    static <T> T find(Class<T> clazz) throws RuntimeException {
        for (ClassLoader classLoader : FactoryFinder.getClassLoaders(Thread.class, FactoryFinder.class, System.class)) {
            if ((classLoader = FactoryFinder.find(clazz, classLoader)) == null) continue;
            return (T)classLoader;
        }
        throw EXCEPTION_HANDLER.createException(null, "Provider for " + clazz.getName() + " cannot be found");
    }

    static <T> T find(Class<T> clazz, ClassLoader classLoader) throws RuntimeException {
        String string = FactoryFinder.fromSystemProperty(clazz.getName());
        if (string != null && (string = FactoryFinder.newInstance(string, clazz, classLoader)) != null) {
            return (T)string;
        }
        string = ServiceLoaderUtil.firstByServiceLoader(clazz, classLoader, logger, EXCEPTION_HANDLER);
        if (string != null) {
            return (T)string;
        }
        if ((clazz = FactoryFinder.lookupUsingHk2ServiceLoader(clazz, classLoader)) != null) {
            return (T)clazz;
        }
        return null;
    }

    private static <T> T newInstance(String string, Class<? extends T> clazz, ClassLoader classLoader) throws RuntimeException {
        return ServiceLoaderUtil.newInstance(string, clazz, classLoader, EXCEPTION_HANDLER);
    }

    private static String fromSystemProperty(String string) {
        string = FactoryFinder.getSystemProperty(string);
        return string;
    }

    private static String getSystemProperty(String string) {
        logger.log(Level.FINE, "Checking system property {0}", string);
        string = AccessController.doPrivileged(new FactoryFinder$2(string));
        FactoryFinder.logFound(string);
        return string;
    }

    private static void logFound(String string) {
        if (string != null) {
            logger.log(Level.FINE, "  found {0}", string);
            return;
        }
        logger.log(Level.FINE, "  not found");
    }

    private static Class<?>[] getHk2ServiceLoaderTargets(Class<?> classLoaderArray) {
        classLoaderArray = FactoryFinder.getClassLoaders(new Class[]{Thread.class, classLoaderArray, System.class});
        Class[] classArray = new Class[classLoaderArray.length];
        int n2 = 0;
        for (ClassLoader classLoader : classLoaderArray) {
            if (classLoader == null) continue;
            try {
                classArray[n2++] = Class.forName("org.glassfish.hk2.osgiresourcelocator.ServiceLoader", false, classLoader);
            }
            catch (Exception | LinkageError throwable) {}
        }
        if (classArray.length != n2) {
            classArray = Arrays.copyOf(classArray, n2);
        }
        return classArray;
    }

    private static <T> T lookupUsingHk2ServiceLoader(Class<T> clazz, ClassLoader classLoader) {
        for (Class<?> clazz2 : FactoryFinder.getHk2ServiceLoaderTargets(clazz)) {
            try {
                Iterator iterator;
                Class[] classArray = Class.forName(clazz.getName(), false, classLoader);
                classArray = new Class[]{classArray};
                Method method = clazz2.getMethod("lookupProviderInstances", Class.class);
                Iterable iterable = (Iterable)method.invoke(null, (Object[])classArray);
                if (iterable == null || !(iterator = iterable.iterator()).hasNext()) continue;
                return clazz.cast(iterator.next());
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private static ClassLoader[] getClassLoaders(Class<?> ... classArray) {
        return AccessController.doPrivileged(new FactoryFinder$3(classArray));
    }
}

