/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.MimetypesFileTypeMap;
import jakarta.activation.SecuritySupport;
import java.io.File;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class FileTypeMap {
    private static FileTypeMap defaultMap = null;
    private static Map<ClassLoader, FileTypeMap> map = new WeakHashMap<ClassLoader, FileTypeMap>();

    public abstract String getContentType(File var1);

    public abstract String getContentType(String var1);

    public static synchronized void setDefaultFileTypeMap(FileTypeMap fileTypeMap) {
        block3: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkSetFactory();
                }
                catch (SecurityException securityException) {
                    ClassLoader classLoader = FileTypeMap.class.getClassLoader();
                    if (classLoader != null && classLoader.getParent() != null && classLoader == fileTypeMap.getClass().getClassLoader()) break block3;
                    throw securityException;
                }
            }
        }
        map.remove(SecuritySupport.getContextClassLoader());
        defaultMap = fileTypeMap;
    }

    public static synchronized FileTypeMap getDefaultFileTypeMap() {
        if (defaultMap != null) {
            return defaultMap;
        }
        ClassLoader classLoader = SecuritySupport.getContextClassLoader();
        FileTypeMap fileTypeMap = map.get(classLoader);
        if (fileTypeMap == null) {
            fileTypeMap = new MimetypesFileTypeMap();
            map.put(classLoader, fileTypeMap);
        }
        return fileTypeMap;
    }
}

