/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import com.sun.activation.registries.LogSupport;
import com.sun.activation.registries.MimeTypeFile;
import jakarta.activation.FileTypeMap;
import jakarta.activation.MimetypesFileTypeMap$1;
import jakarta.activation.SecuritySupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.util.Vector;

public class MimetypesFileTypeMap
extends FileTypeMap {
    private MimeTypeFile[] DB;
    private static final int PROG = 0;
    private static final String defaultType = "application/octet-stream";
    private static final String confDir;

    public MimetypesFileTypeMap() {
        Object object;
        Vector<Object> vector = new Vector<Object>(5);
        vector.addElement(null);
        LogSupport.log("MimetypesFileTypeMap: load HOME");
        try {
            object = System.getProperty("user.home");
            if (object != null) {
                object = (String)object + File.separator + ".mime.types";
                if ((object = this.loadFile((String)object)) != null) {
                    vector.addElement(object);
                }
            }
        }
        catch (SecurityException securityException) {}
        LogSupport.log("MimetypesFileTypeMap: load SYS");
        try {
            if (confDir != null && (object = this.loadFile(confDir + "mime.types")) != null) {
                vector.addElement(object);
            }
        }
        catch (SecurityException securityException) {}
        LogSupport.log("MimetypesFileTypeMap: load JAR");
        this.loadAllResources(vector, "META-INF/mime.types");
        LogSupport.log("MimetypesFileTypeMap: load DEF");
        object = this.loadResource("/META-INF/mimetypes.default");
        if (object != null) {
            vector.addElement(object);
        }
        this.DB = new MimeTypeFile[vector.size()];
        vector.copyInto(this.DB);
    }

    /*
     * Loose catch block
     */
    private MimeTypeFile loadResource(String string) {
        block25: {
            InputStream inputStream;
            block24: {
                block22: {
                    MimeTypeFile mimeTypeFile;
                    block23: {
                        inputStream = null;
                        inputStream = SecuritySupport.getResourceAsStream(this.getClass(), string);
                        if (inputStream == null) break block22;
                        mimeTypeFile = new MimeTypeFile(inputStream);
                        if (!LogSupport.isLoggable()) break block23;
                        LogSupport.log("MimetypesFileTypeMap: successfully loaded mime types file: " + string);
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    return mimeTypeFile;
                }
                if (!LogSupport.isLoggable()) break block24;
                LogSupport.log("MimetypesFileTypeMap: not loading mime types file: " + string);
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block25;
            }
            catch (IOException iOException) {}
            break block25;
            catch (IOException iOException) {
                block26: {
                    if (!LogSupport.isLoggable()) break block26;
                    LogSupport.log("MimetypesFileTypeMap: can't load " + string, iOException);
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    break block25;
                }
                catch (IOException iOException2) {}
                break block25;
            }
            catch (SecurityException securityException) {
                block27: {
                    if (!LogSupport.isLoggable()) break block27;
                    LogSupport.log("MimetypesFileTypeMap: can't load " + string, securityException);
                    {
                        catch (Throwable throwable) {
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                    }
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private void loadAllResources(Vector vector, String string) {
        Object object;
        boolean bl2;
        block25: {
            bl2 = false;
            try {
                object = SecuritySupport.getContextClassLoader();
                if (object == null) {
                    object = this.getClass().getClassLoader();
                }
                if ((object = object != null ? SecuritySupport.getResources((ClassLoader)object, string) : SecuritySupport.getSystemResources(string)) == null) break block25;
                if (LogSupport.isLoggable()) {
                    LogSupport.log("MimetypesFileTypeMap: getResources");
                }
                for (int i2 = 0; i2 < ((URL[])object).length; ++i2) {
                    InputStream inputStream;
                    URL uRL;
                    block26: {
                        uRL = object[i2];
                        inputStream = null;
                        if (LogSupport.isLoggable()) {
                            LogSupport.log("MimetypesFileTypeMap: URL " + uRL);
                        }
                        inputStream = SecuritySupport.openStream(uRL);
                        if (inputStream != null) {
                            vector.addElement(new MimeTypeFile(inputStream));
                            bl2 = true;
                            if (LogSupport.isLoggable()) {
                                LogSupport.log("MimetypesFileTypeMap: successfully loaded mime types from URL: " + uRL);
                            }
                            break block26;
                        }
                        if (!LogSupport.isLoggable()) break block26;
                        LogSupport.log("MimetypesFileTypeMap: not loading mime types from URL: " + uRL);
                    }
                    try {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                    catch (IOException iOException) {
                        block27: {
                            if (!LogSupport.isLoggable()) break block27;
                            LogSupport.log("MimetypesFileTypeMap: can't load " + uRL, iOException);
                        }
                        try {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                        continue;
                    }
                    catch (SecurityException securityException) {
                        block28: {
                            if (!LogSupport.isLoggable()) break block28;
                            LogSupport.log("MimetypesFileTypeMap: can't load " + uRL, securityException);
                            {
                                catch (Throwable throwable) {
                                    try {
                                        if (inputStream != null) {
                                            inputStream.close();
                                        }
                                    }
                                    catch (IOException iOException) {}
                                    throw throwable;
                                }
                            }
                        }
                        try {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                }
            }
            catch (Exception exception) {
                if (!LogSupport.isLoggable()) break block25;
                LogSupport.log("MimetypesFileTypeMap: can't load " + string, exception);
            }
        }
        if (!bl2) {
            LogSupport.log("MimetypesFileTypeMap: !anyLoaded");
            object = this.loadResource("/" + string);
            if (object != null) {
                vector.addElement(object);
            }
        }
    }

    private MimeTypeFile loadFile(String string) {
        MimeTypeFile mimeTypeFile = null;
        try {
            mimeTypeFile = new MimeTypeFile(string);
        }
        catch (IOException iOException) {}
        return mimeTypeFile;
    }

    public MimetypesFileTypeMap(String string) throws IOException {
        this();
        this.DB[0] = new MimeTypeFile(string);
    }

    public MimetypesFileTypeMap(InputStream inputStream) {
        this();
        try {
            this.DB[0] = new MimeTypeFile(inputStream);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public synchronized void addMimeTypes(String string) {
        if (this.DB[0] == null) {
            this.DB[0] = new MimeTypeFile();
        }
        this.DB[0].appendToRegistry(string);
    }

    @Override
    public String getContentType(File file) {
        return ((FileTypeMap)this).getContentType(file.getName());
    }

    @Override
    public synchronized String getContentType(String string) {
        int n2 = string.lastIndexOf(".");
        if (n2 < 0) {
            return defaultType;
        }
        if ((string = string.substring(n2 + 1)).length() == 0) {
            return defaultType;
        }
        for (n2 = 0; n2 < this.DB.length; ++n2) {
            String string2;
            if (this.DB[n2] == null || (string2 = this.DB[n2].getMIMETypeString(string)) == null) continue;
            return string2;
        }
        return defaultType;
    }

    static {
        String string = null;
        try {
            string = (String)AccessController.doPrivileged(new MimetypesFileTypeMap$1());
        }
        catch (Exception exception) {}
        confDir = string;
    }
}

