/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.ActivationDataFlavor;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataSource;
import jakarta.activation.UnsupportedDataTypeException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

class ObjectDataContentHandler
implements DataContentHandler {
    private ActivationDataFlavor[] transferFlavors = null;
    private Object obj;
    private String mimeType;
    private DataContentHandler dch = null;

    public ObjectDataContentHandler(DataContentHandler dataContentHandler, Object object, String string) {
        this.obj = object;
        this.mimeType = string;
        this.dch = dataContentHandler;
    }

    public DataContentHandler getDCH() {
        return this.dch;
    }

    @Override
    public synchronized ActivationDataFlavor[] getTransferDataFlavors() {
        if (this.transferFlavors == null) {
            if (this.dch != null) {
                this.transferFlavors = this.dch.getTransferDataFlavors();
            } else {
                this.transferFlavors = new ActivationDataFlavor[1];
                this.transferFlavors[0] = new ActivationDataFlavor(this.obj.getClass(), this.mimeType, this.mimeType);
            }
        }
        return this.transferFlavors;
    }

    @Override
    public Object getTransferData(ActivationDataFlavor activationDataFlavor, DataSource dataSource) throws IOException {
        if (this.dch != null) {
            return this.dch.getTransferData(activationDataFlavor, dataSource);
        }
        if (activationDataFlavor.equals(this.getTransferDataFlavors()[0])) {
            return this.obj;
        }
        throw new IOException("Unsupported DataFlavor: " + activationDataFlavor);
    }

    @Override
    public Object getContent(DataSource dataSource) {
        return this.obj;
    }

    @Override
    public void writeTo(Object object, String object2, OutputStream outputStream) throws IOException {
        if (this.dch != null) {
            this.dch.writeTo(object, (String)object2, outputStream);
            return;
        }
        if (object instanceof byte[]) {
            outputStream.write((byte[])object);
            return;
        }
        if (object instanceof String) {
            object2 = new OutputStreamWriter(outputStream);
            ((Writer)object2).write((String)object);
            ((OutputStreamWriter)object2).flush();
            return;
        }
        throw new UnsupportedDataTypeException("no object DCH for MIME type " + this.mimeType);
    }
}

