/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.ServiceLoaderUtil$ExceptionHandler;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

class ServiceLoaderUtil {
    ServiceLoaderUtil() {
    }

    static <P, T extends Exception> P firstByServiceLoader(Class<P> clazz, ClassLoader iterator, Logger logger, ServiceLoaderUtil$ExceptionHandler<T> serviceLoaderUtil$ExceptionHandler) throws T {
        logger.log(Level.FINE, "Using java.util.ServiceLoader to find {0}", clazz.getName());
        try {
            iterator = ServiceLoader.load(clazz, (ClassLoader)((Object)iterator));
            iterator = ((ServiceLoader)((Object)iterator)).iterator();
            if (iterator.hasNext()) {
                iterator = iterator.next();
                logger.log(Level.FINE, "ServiceProvider loading Facility used; returning object [{0}]", iterator.getClass().getName());
                return (P)iterator;
            }
        }
        catch (Throwable throwable) {
            throw serviceLoaderUtil$ExceptionHandler.createException(throwable, "Error while searching for service [" + clazz.getName() + "]");
        }
        return null;
    }

    static void checkPackageAccess(String string) {
        int n2;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n2 = string.lastIndexOf(46)) != -1) {
            securityManager.checkPackageAccess(string.substring(0, n2));
        }
    }

    static <P> Class<P> nullSafeLoadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return Class.forName(string, false, classLoader);
    }

    static <P, T extends Exception> P newInstance(String string, Class<P> clazz, ClassLoader object, ServiceLoaderUtil$ExceptionHandler<T> serviceLoaderUtil$ExceptionHandler) throws T {
        try {
            object = ServiceLoaderUtil.safeLoadClass(string, (ClassLoader)object);
            return clazz.cast(((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw serviceLoaderUtil$ExceptionHandler.createException(classNotFoundException, "Provider " + string + " not found");
        }
        catch (Exception exception) {
            throw serviceLoaderUtil$ExceptionHandler.createException(exception, "Provider " + string + " could not be instantiated: " + exception);
        }
    }

    static <P> Class<P> safeLoadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        ServiceLoaderUtil.checkPackageAccess(string);
        return ServiceLoaderUtil.nullSafeLoadClass(string, classLoader);
    }
}

