/*
 * Decompiled with CFR 0.152.
 */
package jakarta.xml.bind;

import jakarta.xml.bind.ServiceLoaderUtil$ExceptionHandler;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

class ServiceLoaderUtil {
    private static final String OSGI_SERVICE_LOADER_CLASS_NAME = "org.glassfish.hk2.osgiresourcelocator.ServiceLoader";
    private static final String OSGI_SERVICE_LOADER_METHOD_NAME = "lookupProviderClasses";

    ServiceLoaderUtil() {
    }

    static <P, T extends Exception> P firstByServiceLoader(Class<P> clazz, Logger logger, ServiceLoaderUtil$ExceptionHandler<T> serviceLoaderUtil$ExceptionHandler) throws T {
        try {
            Object object = ServiceLoader.load(clazz);
            object = ((ServiceLoader)object).iterator();
            if (object.hasNext()) {
                object = object.next();
                logger.log(Level.FINE, "ServiceProvider loading Facility used; returning object [{0}]", object.getClass().getName());
                return (P)object;
            }
        }
        catch (Throwable throwable) {
            throw serviceLoaderUtil$ExceptionHandler.createException(throwable, "Error while searching for service [" + clazz.getName() + "]");
        }
        return null;
    }

    static <T> T lookupUsingOSGiServiceLoader(String string, Logger logger) {
        block2: {
            try {
                Object object = Class.forName(string);
                GenericDeclaration genericDeclaration = Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME);
                genericDeclaration = genericDeclaration.getMethod(OSGI_SERVICE_LOADER_METHOD_NAME, Class.class);
                object = ((Iterable)((Method)genericDeclaration).invoke(null, object)).iterator();
                if (!object.hasNext()) break block2;
                object = object.next();
                logger.log(Level.FINE, "Found implementation using OSGi facility; returning object [{0}].", object.getClass().getName());
                return (T)object;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                logger.log(Level.FINE, "Unable to find from OSGi: [" + string + "]", reflectiveOperationException);
                return null;
            }
        }
        return null;
    }

    static <T> Iterable<T> lookupsUsingOSGiServiceLoader(String string, Logger logger) {
        try {
            return (Iterable)Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME).getMethod(OSGI_SERVICE_LOADER_METHOD_NAME, Class.class).invoke(null, Class.forName(string));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            logger.log(Level.FINE, reflectiveOperationException, () -> "Unable to find from OSGi: [" + string + "]");
            return null;
        }
    }

    static void checkPackageAccess(String string) {
        int n2;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n2 = string.lastIndexOf(46)) != -1) {
            securityManager.checkPackageAccess(string.substring(0, n2));
        }
    }

    static Class<?> nullSafeLoadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            return Class.forName(string);
        }
        return classLoader.loadClass(string);
    }

    static <T extends Exception> Object newInstance(String string, String string2, ServiceLoaderUtil$ExceptionHandler<T> serviceLoaderUtil$ExceptionHandler) throws T {
        try {
            return ServiceLoaderUtil.safeLoadClass(string, string2, ServiceLoaderUtil.contextClassLoader(serviceLoaderUtil$ExceptionHandler)).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw serviceLoaderUtil$ExceptionHandler.createException(classNotFoundException, "Provider " + string + " not found");
        }
        catch (Exception exception) {
            throw serviceLoaderUtil$ExceptionHandler.createException(exception, "Provider " + string + " could not be instantiated: " + String.valueOf(exception));
        }
    }

    static Class<?> safeLoadClass(String string, String string2, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            ServiceLoaderUtil.checkPackageAccess(string);
        }
        catch (SecurityException securityException) {
            if (string2 != null && string2.equals(string)) {
                return Class.forName(string);
            }
            throw securityException;
        }
        return ServiceLoaderUtil.nullSafeLoadClass(string, classLoader);
    }

    static <T extends Exception> ClassLoader contextClassLoader(ServiceLoaderUtil$ExceptionHandler<T> serviceLoaderUtil$ExceptionHandler) throws T {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw serviceLoaderUtil$ExceptionHandler.createException(exception2, exception2.toString());
        }
    }
}

