/*
 * Decompiled with CFR 0.152.
 */
package jakarta.xml.bind.helpers;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.UnmarshalException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.Unmarshaller$Listener;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.attachment.AttachmentUnmarshaller;
import jakarta.xml.bind.helpers.DefaultValidationEventHandler;
import jakarta.xml.bind.helpers.Messages;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class AbstractUnmarshallerImpl
implements Unmarshaller {
    private ValidationEventHandler eventHandler = new DefaultValidationEventHandler();
    private XMLReader reader = null;
    private SAXParserFactory parserFactory;

    protected AbstractUnmarshallerImpl() {
    }

    private SAXParserFactory getSAXParserFactory() {
        if (this.parserFactory == null) {
            this.parserFactory = SAXParserFactory.newInstance();
            this.parserFactory.setNamespaceAware(true);
            this.parserFactory.setValidating(false);
        }
        return this.parserFactory;
    }

    protected XMLReader getXMLReader() throws JAXBException {
        if (this.reader == null) {
            try {
                this.reader = this.getSAXParserFactory().newSAXParser().getXMLReader();
            }
            catch (ParserConfigurationException | SAXException exception) {
                throw new JAXBException(exception);
            }
        }
        return this.reader;
    }

    @Override
    public Object unmarshal(Source source) throws JAXBException {
        if (source == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "source"));
        }
        if (source instanceof SAXSource) {
            return this.unmarshal((SAXSource)source);
        }
        if (source instanceof StreamSource) {
            return this.unmarshal(AbstractUnmarshallerImpl.streamSourceToInputSource((StreamSource)source));
        }
        if (source instanceof DOMSource) {
            return this.unmarshal(((DOMSource)source).getNode());
        }
        throw new IllegalArgumentException();
    }

    private Object unmarshal(SAXSource sAXSource) throws JAXBException {
        XMLReader xMLReader = sAXSource.getXMLReader();
        if (xMLReader == null) {
            xMLReader = this.getXMLReader();
        }
        return this.unmarshal(xMLReader, sAXSource.getInputSource());
    }

    protected abstract Object unmarshal(XMLReader var1, InputSource var2) throws JAXBException;

    @Override
    public final Object unmarshal(InputSource inputSource) throws JAXBException {
        if (inputSource == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "source"));
        }
        AbstractUnmarshallerImpl abstractUnmarshallerImpl = this;
        return abstractUnmarshallerImpl.unmarshal(abstractUnmarshallerImpl.getXMLReader(), inputSource);
    }

    private Object unmarshal(String string) throws JAXBException {
        return this.unmarshal(new InputSource(string));
    }

    @Override
    public final Object unmarshal(URL uRL) throws JAXBException {
        if (uRL == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "url"));
        }
        return this.unmarshal(uRL.toExternalForm());
    }

    @Override
    public final Object unmarshal(File file) throws JAXBException {
        if (file == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "file"));
        }
        try {
            return this.unmarshal(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException(fileNotFoundException.getMessage());
        }
    }

    @Override
    public final Object unmarshal(InputStream object) throws JAXBException {
        if (object == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "is"));
        }
        object = new InputSource((InputStream)object);
        return this.unmarshal((InputSource)object);
    }

    @Override
    public final Object unmarshal(Reader object) throws JAXBException {
        if (object == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "reader"));
        }
        object = new InputSource((Reader)object);
        return this.unmarshal((InputSource)object);
    }

    private static InputSource streamSourceToInputSource(StreamSource streamSource) {
        InputSource inputSource = new InputSource();
        inputSource.setSystemId(streamSource.getSystemId());
        inputSource.setByteStream(streamSource.getInputStream());
        inputSource.setCharacterStream(streamSource.getReader());
        return inputSource;
    }

    @Override
    public void setEventHandler(ValidationEventHandler validationEventHandler) throws JAXBException {
        if (validationEventHandler == null) {
            this.eventHandler = new DefaultValidationEventHandler();
            return;
        }
        this.eventHandler = validationEventHandler;
    }

    @Override
    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.eventHandler;
    }

    protected UnmarshalException createUnmarshalException(SAXException sAXException) {
        Exception exception = sAXException.getException();
        if (exception instanceof UnmarshalException) {
            return (UnmarshalException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception != null) {
            return new UnmarshalException(exception);
        }
        return new UnmarshalException(sAXException);
    }

    @Override
    public void setProperty(String string, Object object) throws PropertyException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "name"));
        }
        throw new PropertyException(string, object);
    }

    @Override
    public Object getProperty(String string) throws PropertyException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "name"));
        }
        throw new PropertyException(string);
    }

    @Override
    public Object unmarshal(XMLEventReader xMLEventReader) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object unmarshal(XMLStreamReader xMLStreamReader) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> JAXBElement<T> unmarshal(Node node, Class<T> clazz) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> JAXBElement<T> unmarshal(Source source, Class<T> clazz) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> JAXBElement<T> unmarshal(XMLStreamReader xMLStreamReader, Class<T> clazz) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> JAXBElement<T> unmarshal(XMLEventReader xMLEventReader, Class<T> clazz) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSchema(Schema schema) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Schema getSchema() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends XmlAdapter<?, ?>> void setAdapter(A a2) {
        if (a2 == null) {
            throw new IllegalArgumentException();
        }
        this.setAdapter(a2.getClass(), a2);
    }

    @Override
    public <A extends XmlAdapter<?, ?>> void setAdapter(Class<A> clazz, A a2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A extends XmlAdapter<?, ?>> A getAdapter(Class<A> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttachmentUnmarshaller(AttachmentUnmarshaller attachmentUnmarshaller) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setListener(Unmarshaller$Listener unmarshaller$Listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Unmarshaller$Listener getListener() {
        throw new UnsupportedOperationException();
    }
}

