/*
 * Decompiled with CFR 0.152.
 */
package jakarta.xml.bind.helpers;

import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.helpers.Messages;
import java.net.URL;
import org.w3c.dom.Node;

public class DefaultValidationEventHandler
implements ValidationEventHandler {
    @Override
    public boolean handleEvent(ValidationEvent validationEvent) {
        if (validationEvent == null) {
            throw new IllegalArgumentException();
        }
        String string = null;
        boolean bl2 = false;
        switch (validationEvent.getSeverity()) {
            case 0: {
                string = Messages.format("DefaultValidationEventHandler.Warning");
                bl2 = true;
                break;
            }
            case 1: {
                string = Messages.format("DefaultValidationEventHandler.Error");
                bl2 = false;
                break;
            }
            case 2: {
                string = Messages.format("DefaultValidationEventHandler.FatalError");
                bl2 = false;
                break;
            }
            default: {
                assert (false) : Messages.format("DefaultValidationEventHandler.UnrecognizedSeverity", validationEvent.getSeverity());
                break;
            }
        }
        String string2 = this.getLocation(validationEvent);
        System.out.println(Messages.format("DefaultValidationEventHandler.SeverityMessage", string, validationEvent.getMessage(), string2));
        return bl2;
    }

    private String getLocation(ValidationEvent object) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((object = object.getLocator()) != null) {
            URL uRL = object.getURL();
            Object object2 = object.getObject();
            Node node = object.getNode();
            int n2 = object.getLineNumber();
            if (uRL != null || n2 != -1) {
                stringBuilder.append("line ").append(n2);
                if (uRL != null) {
                    stringBuilder.append(" of ").append(uRL);
                }
            } else if (object2 != null) {
                stringBuilder.append(" obj: ").append(object2);
            } else if (node != null) {
                stringBuilder.append(" node: ").append(node);
            }
        } else {
            stringBuilder.append(Messages.format("DefaultValidationEventHandler.LocationUnavailable"));
        }
        return stringBuilder.toString();
    }
}

