/*
 * Decompiled with CFR 0.152.
 */
package jakarta.xml.bind.util;

import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.util.Messages;
import java.util.ArrayList;
import java.util.List;

public class ValidationEventCollector
implements ValidationEventHandler {
    private final List<ValidationEvent> events = new ArrayList<ValidationEvent>();

    public ValidationEvent[] getEvents() {
        return this.events.toArray(new ValidationEvent[0]);
    }

    public void reset() {
        this.events.clear();
    }

    public boolean hasEvents() {
        return !this.events.isEmpty();
    }

    @Override
    public boolean handleEvent(ValidationEvent validationEvent) {
        this.events.add(validationEvent);
        boolean bl2 = true;
        switch (validationEvent.getSeverity()) {
            case 0: 
            case 1: {
                bl2 = true;
                break;
            }
            case 2: {
                bl2 = false;
                break;
            }
            default: {
                ValidationEventCollector._assert(false, Messages.format("ValidationEventCollector.UnrecognizedSeverity", validationEvent.getSeverity()));
            }
        }
        return bl2;
    }

    private static void _assert(boolean bl2, String string) {
        if (!bl2) {
            throw new InternalError(string);
        }
    }
}

