/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.javafx.animation.TickCalculation;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import com.sun.scenario.animation.AbstractPrimaryTimer;
import com.sun.scenario.animation.shared.ClipEnvelope;
import com.sun.scenario.animation.shared.PulseReceiver;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Objects;
import javafx.animation.Animation$1;
import javafx.animation.Animation$2;
import javafx.animation.Animation$3;
import javafx.animation.Animation$4;
import javafx.animation.Animation$5;
import javafx.animation.Animation$6;
import javafx.animation.Animation$AnimationReadOnlyProperty;
import javafx.animation.Animation$CurrentRateProperty;
import javafx.animation.Animation$CurrentTimeProperty;
import javafx.animation.Animation$Status;
import javafx.animation.AnimationAccessorImpl;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.util.Duration;

public abstract class Animation {
    public static final int INDEFINITE = -1;
    private static final double EPSILON = 1.0E-12;
    private long startTime;
    private long pauseTime;
    private boolean paused = false;
    private final AbstractPrimaryTimer timer;
    private AccessControlContext accessCtrlCtx = null;
    final PulseReceiver pulseReceiver = new Animation$1(this);
    Animation parent = null;
    ClipEnvelope clipEnvelope;
    private boolean lastPlayedFinished = true;
    private boolean lastPlayedForward = true;
    private DoubleProperty rate;
    private static final double DEFAULT_RATE = 1.0;
    private double oldRate = 1.0;
    private ReadOnlyDoubleProperty currentRate;
    private static final double DEFAULT_CURRENT_RATE = 0.0;
    private ReadOnlyObjectProperty<Duration> cycleDuration;
    private static final Duration DEFAULT_CYCLE_DURATION;
    private ReadOnlyObjectProperty<Duration> totalDuration;
    private static final Duration DEFAULT_TOTAL_DURATION;
    private Animation$CurrentTimeProperty currentTime;
    private long currentTicks;
    private ObjectProperty<Duration> delay;
    private static final Duration DEFAULT_DELAY;
    private IntegerProperty cycleCount;
    private static final int DEFAULT_CYCLE_COUNT = 1;
    private BooleanProperty autoReverse;
    private static final boolean DEFAULT_AUTO_REVERSE = false;
    private ReadOnlyObjectProperty<Animation$Status> status;
    private static final Animation$Status DEFAULT_STATUS;
    private ObjectProperty<EventHandler<ActionEvent>> onFinished;
    private static final EventHandler<ActionEvent> DEFAULT_ON_FINISHED;
    private ObservableMap<String, Duration> cuePoints;
    private final double targetFramerate;
    private final int resolution;
    private long lastPulse;

    static final boolean isNearZero(double d2) {
        return Math.abs(d2) < 1.0E-12;
    }

    private static boolean areNearEqual(double d2, double d3) {
        return Animation.isNearZero(d3 - d2);
    }

    private long now() {
        return TickCalculation.fromNano(this.timer.nanos());
    }

    private void addPulseReceiver() {
        this.accessCtrlCtx = AccessController.getContext();
        this.timer.addPulseReceiver(this.pulseReceiver);
    }

    void startReceiver(long l2) {
        this.paused = false;
        this.startTime = this.now() + l2;
        this.addPulseReceiver();
    }

    void pauseReceiver() {
        if (!this.paused) {
            this.pauseTime = this.now();
            this.paused = true;
            this.timer.removePulseReceiver(this.pulseReceiver);
        }
    }

    void resumeReceiver() {
        if (this.paused) {
            long l2 = this.now() - this.pauseTime;
            this.startTime += l2;
            this.paused = false;
            this.addPulseReceiver();
        }
    }

    public final void setRate(double d2) {
        if (this.rate != null || !Animation.areNearEqual(d2, 1.0)) {
            this.rateProperty().set(d2);
        }
    }

    public final double getRate() {
        if (this.rate == null) {
            return 1.0;
        }
        return this.rate.get();
    }

    public final DoubleProperty rateProperty() {
        if (this.rate == null) {
            this.rate = new Animation$2(this, 1.0);
        }
        return this.rate;
    }

    private boolean isRunningEmbedded() {
        if (this.parent == null) {
            return false;
        }
        return !this.parent.isStopped() || this.parent.isRunningEmbedded();
    }

    public final double getCurrentRate() {
        if (this.currentRate == null) {
            return 0.0;
        }
        return this.currentRate.get();
    }

    public final ReadOnlyDoubleProperty currentRateProperty() {
        if (this.currentRate == null) {
            this.currentRate = new Animation$CurrentRateProperty(this);
        }
        return this.currentRate;
    }

    void setCurrentRate(double d2) {
        this.doSetCurrentRate(d2);
    }

    private void doSetCurrentRate(double d2) {
        if (this.currentRate != null || !Animation.areNearEqual(d2, 0.0)) {
            ((Animation$CurrentRateProperty)this.currentRateProperty()).set(d2);
        }
    }

    protected final void setCycleDuration(Duration duration) {
        if (this.cycleDuration != null || !DEFAULT_CYCLE_DURATION.equals(duration)) {
            if (duration.lessThan(Duration.ZERO)) {
                throw new IllegalArgumentException("Cycle duration cannot be negative");
            }
            ((Animation$AnimationReadOnlyProperty)this.cycleDurationProperty()).set(duration);
            this.updateTotalDuration();
        }
    }

    public final Duration getCycleDuration() {
        if (this.cycleDuration == null) {
            return DEFAULT_CYCLE_DURATION;
        }
        return (Duration)this.cycleDuration.get();
    }

    public final ReadOnlyObjectProperty<Duration> cycleDurationProperty() {
        if (this.cycleDuration == null) {
            this.cycleDuration = new Animation$AnimationReadOnlyProperty<Duration>(this, "cycleDuration", DEFAULT_CYCLE_DURATION);
        }
        return this.cycleDuration;
    }

    public final Duration getTotalDuration() {
        if (this.totalDuration == null) {
            return DEFAULT_TOTAL_DURATION;
        }
        return (Duration)this.totalDuration.get();
    }

    public final ReadOnlyObjectProperty<Duration> totalDurationProperty() {
        if (this.totalDuration == null) {
            this.totalDuration = new Animation$AnimationReadOnlyProperty<Duration>(this, "totalDuration", DEFAULT_TOTAL_DURATION);
        }
        return this.totalDuration;
    }

    private void updateTotalDuration() {
        int n2 = this.getCycleCount();
        Duration duration = this.getCycleDuration();
        Duration duration2 = Duration.ZERO.equals(duration) ? Duration.ZERO : (n2 == -1 ? Duration.INDEFINITE : (n2 <= 1 ? duration : duration.multiply(n2)));
        if (this.totalDuration != null || !DEFAULT_TOTAL_DURATION.equals(duration2)) {
            ((Animation$AnimationReadOnlyProperty)this.totalDurationProperty()).set(duration2);
        }
        if (this.isStopped()) {
            this.syncClipEnvelope();
            if (duration2.lessThan(this.getCurrentTime())) {
                this.clipEnvelope.jumpTo(TickCalculation.fromDuration(duration2));
            }
        }
    }

    public final Duration getCurrentTime() {
        return TickCalculation.toDuration(this.currentTicks);
    }

    public final ReadOnlyObjectProperty<Duration> currentTimeProperty() {
        if (this.currentTime == null) {
            this.currentTime = new Animation$CurrentTimeProperty(this);
        }
        return this.currentTime;
    }

    public final void setDelay(Duration duration) {
        if (this.delay != null || !DEFAULT_DELAY.equals(duration)) {
            this.delayProperty().set(duration);
        }
    }

    public final Duration getDelay() {
        if (this.delay == null) {
            return DEFAULT_DELAY;
        }
        return (Duration)this.delay.get();
    }

    public final ObjectProperty<Duration> delayProperty() {
        if (this.delay == null) {
            this.delay = new Animation$3(this, DEFAULT_DELAY);
        }
        return this.delay;
    }

    public final void setCycleCount(int n2) {
        if (this.cycleCount != null || n2 != 1) {
            this.cycleCountProperty().set(n2);
        }
    }

    public final int getCycleCount() {
        if (this.cycleCount == null) {
            return 1;
        }
        return this.cycleCount.get();
    }

    public final IntegerProperty cycleCountProperty() {
        if (this.cycleCount == null) {
            this.cycleCount = new Animation$4(this, 1);
        }
        return this.cycleCount;
    }

    public final void setAutoReverse(boolean bl2) {
        if (this.autoReverse != null || bl2) {
            this.autoReverseProperty().set(bl2);
        }
    }

    public final boolean isAutoReverse() {
        if (this.autoReverse == null) {
            return false;
        }
        return this.autoReverse.get();
    }

    public final BooleanProperty autoReverseProperty() {
        if (this.autoReverse == null) {
            this.autoReverse = new Animation$5(this, false);
        }
        return this.autoReverse;
    }

    protected final void setStatus(Animation$Status animation$Status) {
        if (this.status != null || !DEFAULT_STATUS.equals((Object)animation$Status)) {
            ((Animation$AnimationReadOnlyProperty)this.statusProperty()).set(animation$Status);
        }
    }

    public final Animation$Status getStatus() {
        if (this.status == null) {
            return DEFAULT_STATUS;
        }
        return (Animation$Status)((Object)this.status.get());
    }

    public final ReadOnlyObjectProperty<Animation$Status> statusProperty() {
        if (this.status == null) {
            this.status = new Animation$AnimationReadOnlyProperty<Animation$Status>(this, "status", Animation$Status.STOPPED);
        }
        return this.status;
    }

    boolean isStopped() {
        return this.getStatus() == Animation$Status.STOPPED;
    }

    boolean isPaused() {
        return this.getStatus() == Animation$Status.PAUSED;
    }

    boolean isRunning() {
        return this.getStatus() == Animation$Status.RUNNING;
    }

    public final void setOnFinished(EventHandler<ActionEvent> eventHandler) {
        if (this.onFinished != null || eventHandler != DEFAULT_ON_FINISHED) {
            this.onFinishedProperty().set(eventHandler);
        }
    }

    public final EventHandler<ActionEvent> getOnFinished() {
        if (this.onFinished == null) {
            return DEFAULT_ON_FINISHED;
        }
        return (EventHandler)this.onFinished.get();
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onFinishedProperty() {
        if (this.onFinished == null) {
            this.onFinished = new Animation$6(this, DEFAULT_ON_FINISHED);
        }
        return this.onFinished;
    }

    public final ObservableMap<String, Duration> getCuePoints() {
        if (this.cuePoints == null) {
            this.cuePoints = FXCollections.observableHashMap();
        }
        return this.cuePoints;
    }

    public void jumpTo(Duration duration) {
        Objects.requireNonNull(duration, "Time needs to be specified");
        if (duration.isUnknown()) {
            throw new IllegalArgumentException("The time is invalid");
        }
        if (this.parent != null) {
            throw new IllegalStateException("Cannot jump when embedded in another animation");
        }
        this.lastPlayedFinished = false;
        double d2 = duration.isIndefinite() ? this.getCycleDuration().toMillis() : Utils.clamp(0.0, duration.toMillis(), this.getTotalDuration().toMillis());
        long l2 = TickCalculation.fromMillis(d2);
        if (this.isStopped()) {
            this.syncClipEnvelope();
        }
        this.clipEnvelope.jumpTo(l2);
    }

    public void jumpTo(String object) {
        Objects.requireNonNull(object, "CuePoint needs to be specified");
        if ("start".equalsIgnoreCase((String)object)) {
            this.jumpTo(Duration.ZERO);
            return;
        }
        if ("end".equalsIgnoreCase((String)object)) {
            Animation animation = this;
            animation.jumpTo(animation.getTotalDuration());
            return;
        }
        object = (Duration)this.getCuePoints().get(object);
        if (object != null) {
            this.jumpTo((Duration)object);
        }
    }

    public void playFrom(String string) {
        this.jumpTo(string);
        this.play();
    }

    public void playFrom(Duration duration) {
        this.jumpTo(duration);
        this.play();
    }

    public void playFromStart() {
        this.stop();
        Animation animation = this;
        animation.setRate(Math.abs(animation.getRate()));
        this.jumpTo(Duration.ZERO);
        this.play();
    }

    public void play() {
        if (this.parent != null) {
            throw new IllegalStateException("Cannot start when embedded in another animation");
        }
        switch (this.getStatus()) {
            case STOPPED: {
                if (this.startable(true)) {
                    double d2 = this.getRate();
                    if (this.lastPlayedFinished) {
                        this.jumpTo(d2 < 0.0 ? this.getTotalDuration() : Duration.ZERO);
                    }
                    this.doStart(true);
                    Animation animation = this;
                    animation.startReceiver(TickCalculation.fromDuration(animation.getDelay()));
                    if (Animation.isNearZero(d2)) {
                        this.pauseReceiver();
                    }
                    return;
                }
                Animation animation = this;
                animation.runHandler(animation.getOnFinished());
                return;
            }
            case PAUSED: {
                this.doResume();
                if (Animation.isNearZero(this.getRate())) break;
                this.resumeReceiver();
            }
        }
    }

    void doStart(boolean bl2) {
        this.sync(bl2);
        this.setStatus(Animation$Status.RUNNING);
        this.clipEnvelope.start();
        Animation animation = this;
        animation.doSetCurrentRate(animation.clipEnvelope.getCurrentRate());
        this.lastPulse = 0L;
    }

    void doResume() {
        this.setStatus(Animation$Status.RUNNING);
        Animation animation = this;
        animation.doSetCurrentRate(animation.lastPlayedForward ? this.getRate() : -this.getRate());
    }

    public void stop() {
        if (this.parent != null) {
            throw new IllegalStateException("Cannot stop when embedded in another animation");
        }
        if (!this.isStopped()) {
            this.clipEnvelope.abortCurrentPulse();
            this.doStop();
            this.jumpTo(Duration.ZERO);
            this.lastPlayedFinished = true;
        }
    }

    void doStop() {
        if (!this.paused) {
            this.timer.removePulseReceiver(this.pulseReceiver);
        }
        this.setStatus(Animation$Status.STOPPED);
        this.doSetCurrentRate(0.0);
    }

    public void pause() {
        if (this.parent != null) {
            throw new IllegalStateException("Cannot pause when embedded in another animation");
        }
        if (this.isRunning()) {
            this.clipEnvelope.abortCurrentPulse();
            this.pauseReceiver();
            this.doPause();
        }
    }

    void doPause() {
        double d2 = this.getCurrentRate();
        if (!Animation.isNearZero(d2)) {
            this.lastPlayedForward = Animation.areNearEqual(this.getCurrentRate(), this.getRate());
        }
        this.doSetCurrentRate(0.0);
        this.setStatus(Animation$Status.PAUSED);
    }

    final void finished() {
        this.lastPlayedFinished = true;
        this.doStop();
        Animation animation = this;
        animation.runHandler(animation.getOnFinished());
    }

    void runHandler(EventHandler<ActionEvent> eventHandler) {
        if (eventHandler != null) {
            try {
                eventHandler.handle(new ActionEvent(this, null));
                return;
            }
            catch (Exception exception) {
                Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), exception);
            }
        }
    }

    public final double getTargetFramerate() {
        return this.targetFramerate;
    }

    protected Animation(double d2) {
        this.targetFramerate = d2;
        this.resolution = (int)Math.max(1L, Math.round(6000.0 / d2));
        this.clipEnvelope = ClipEnvelope.create(this);
        this.timer = Toolkit.getToolkit().getPrimaryTimer();
    }

    protected Animation() {
        this.resolution = 1;
        this.targetFramerate = 6000 / Toolkit.getToolkit().getPrimaryTimer().getDefaultResolution();
        this.clipEnvelope = ClipEnvelope.create(this);
        this.timer = Toolkit.getToolkit().getPrimaryTimer();
    }

    Animation(AbstractPrimaryTimer abstractPrimaryTimer) {
        this.resolution = 1;
        this.targetFramerate = 6000 / abstractPrimaryTimer.getDefaultResolution();
        this.clipEnvelope = ClipEnvelope.create(this);
        this.timer = abstractPrimaryTimer;
    }

    Animation(AbstractPrimaryTimer abstractPrimaryTimer, ClipEnvelope clipEnvelope, int n2) {
        this.resolution = n2;
        this.targetFramerate = 6000 / n2;
        this.clipEnvelope = clipEnvelope;
        this.timer = abstractPrimaryTimer;
    }

    boolean startable(boolean bl2) {
        return TickCalculation.fromDuration(this.getCycleDuration()) > 0L || !bl2 && this.clipEnvelope.wasSynched();
    }

    void sync(boolean bl2) {
        if (bl2 || !this.clipEnvelope.wasSynched()) {
            this.syncClipEnvelope();
        }
    }

    private void syncClipEnvelope() {
        int n2 = this.getCycleCount();
        n2 = n2 <= 0 && n2 != -1 ? 1 : n2;
        this.clipEnvelope = this.clipEnvelope.setCycleCount(n2);
        this.clipEnvelope.setCycleDuration(this.getCycleDuration());
        this.clipEnvelope.setAutoReverse(this.isAutoReverse());
    }

    void doTimePulse(long l2) {
        if (this.resolution == 1) {
            this.clipEnvelope.timePulse(l2);
            return;
        }
        if (l2 - this.lastPulse >= (long)this.resolution) {
            this.lastPulse = l2 / (long)this.resolution * (long)this.resolution;
            this.clipEnvelope.timePulse(l2);
        }
    }

    abstract void doPlayTo(long var1, long var3);

    abstract void doJumpTo(long var1, long var3, boolean var5);

    void setCurrentTicks(long l2) {
        this.currentTicks = l2;
        if (this.currentTime != null) {
            this.currentTime.fireValueChangedEvent();
        }
    }

    static {
        AnimationAccessorImpl.DEFAULT = new AnimationAccessorImpl();
        DEFAULT_CYCLE_DURATION = Duration.ZERO;
        DEFAULT_TOTAL_DURATION = Duration.ZERO;
        DEFAULT_DELAY = Duration.ZERO;
        DEFAULT_STATUS = Animation$Status.STOPPED;
        DEFAULT_ON_FINISHED = null;
    }
}

