/*
 * Decompiled with CFR 0.152.
 */
package javafx.animation;

import com.sun.javafx.animation.KeyValueHelper;
import com.sun.javafx.animation.KeyValueType;
import javafx.animation.Interpolator;
import javafx.animation.KeyValue$1;
import javafx.beans.NamedArg;
import javafx.beans.value.WritableBooleanValue;
import javafx.beans.value.WritableDoubleValue;
import javafx.beans.value.WritableFloatValue;
import javafx.beans.value.WritableIntegerValue;
import javafx.beans.value.WritableLongValue;
import javafx.beans.value.WritableNumberValue;
import javafx.beans.value.WritableValue;

public final class KeyValue {
    private static final Interpolator DEFAULT_INTERPOLATOR = Interpolator.LINEAR;
    private final KeyValueType type;
    private final WritableValue<?> target;
    private final Object endValue;
    private final Interpolator interpolator;

    final KeyValueType getType() {
        return this.type;
    }

    public final WritableValue<?> getTarget() {
        return this.target;
    }

    public final Object getEndValue() {
        return this.endValue;
    }

    public final Interpolator getInterpolator() {
        return this.interpolator;
    }

    public <T> KeyValue(@NamedArg(value="target") WritableValue<T> writableValue, @NamedArg(value="endValue") T t2, @NamedArg(value="interpolator") Interpolator interpolator) {
        if (writableValue == null) {
            throw new NullPointerException("Target needs to be specified");
        }
        if (interpolator == null) {
            throw new NullPointerException("Interpolator needs to be specified");
        }
        this.target = writableValue;
        this.endValue = t2;
        this.interpolator = interpolator;
        this.type = writableValue instanceof WritableNumberValue ? (writableValue instanceof WritableDoubleValue ? KeyValueType.DOUBLE : (writableValue instanceof WritableIntegerValue ? KeyValueType.INTEGER : (writableValue instanceof WritableFloatValue ? KeyValueType.FLOAT : (writableValue instanceof WritableLongValue ? KeyValueType.LONG : KeyValueType.OBJECT)))) : (writableValue instanceof WritableBooleanValue ? KeyValueType.BOOLEAN : KeyValueType.OBJECT);
    }

    public <T> KeyValue(@NamedArg(value="target") WritableValue<T> writableValue, @NamedArg(value="endValue") T t2) {
        this(writableValue, t2, DEFAULT_INTERPOLATOR);
    }

    public final String toString() {
        return "KeyValue [target=" + String.valueOf(this.target) + ", endValue=" + String.valueOf(this.endValue) + ", interpolator=" + String.valueOf(this.interpolator) + "]";
    }

    public final int hashCode() {
        assert (this.target != null && this.interpolator != null);
        int n2 = 31 + this.target.hashCode();
        n2 = n2 * 31 + (this.endValue == null ? 0 : this.endValue.hashCode());
        n2 = n2 * 31 + this.interpolator.hashCode();
        return n2;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof KeyValue) {
            object = (KeyValue)object;
            assert (this.target != null && this.interpolator != null && ((KeyValue)object).target != null && ((KeyValue)object).interpolator != null);
            return this.target.equals(((KeyValue)object).target) && (this.endValue == null ? ((KeyValue)object).endValue == null : this.endValue.equals(((KeyValue)object).endValue)) && this.interpolator.equals(((KeyValue)object).interpolator);
        }
        return false;
    }

    static {
        KeyValueHelper.setKeyValueAccessor(new KeyValue$1());
    }
}

