/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.binding;

import com.sun.javafx.binding.StringFormatter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ListExpression$1;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableListValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public abstract class ListExpression<E>
implements ObservableListValue<E> {
    @Override
    public ObservableList<E> getValue() {
        return (ObservableList)this.get();
    }

    public static <E> ListExpression<E> listExpression(ObservableListValue<E> observableListValue) {
        if (observableListValue == null) {
            throw new NullPointerException("List must be specified.");
        }
        if (observableListValue instanceof ListExpression) {
            return (ListExpression)observableListValue;
        }
        return new ListExpression$1(observableListValue);
    }

    public int getSize() {
        return this.size();
    }

    public abstract ReadOnlyIntegerProperty sizeProperty();

    public abstract ReadOnlyBooleanProperty emptyProperty();

    public ObjectBinding<E> valueAt(int n2) {
        return Bindings.valueAt(this, n2);
    }

    public ObjectBinding<E> valueAt(ObservableIntegerValue observableIntegerValue) {
        return Bindings.valueAt(this, observableIntegerValue);
    }

    public BooleanBinding isEqualTo(ObservableList<?> observableList) {
        return Bindings.equal(this, observableList);
    }

    public BooleanBinding isNotEqualTo(ObservableList<?> observableList) {
        return Bindings.notEqual(this, observableList);
    }

    public BooleanBinding isNull() {
        return Bindings.isNull(this);
    }

    public BooleanBinding isNotNull() {
        return Bindings.isNotNull(this);
    }

    public StringBinding asString() {
        return (StringBinding)StringFormatter.convert(this);
    }

    @Override
    public int size() {
        return this.getNonNull().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getNonNull().isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.getNonNull().contains(object);
    }

    @Override
    public Iterator<E> iterator() {
        return this.getNonNull().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getNonNull().toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.getNonNull().toArray(TArray);
    }

    @Override
    public boolean add(E e2) {
        return this.getNonNull().add(e2);
    }

    @Override
    public boolean remove(Object object) {
        return this.getNonNull().remove(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.getNonNull().containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.getNonNull().addAll(collection);
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        return this.getNonNull().addAll(n2, collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.getNonNull().removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.getNonNull().retainAll(collection);
    }

    @Override
    public void clear() {
        this.getNonNull().clear();
    }

    @Override
    public E get(int n2) {
        return this.getNonNull().get(n2);
    }

    @Override
    public E set(int n2, E e2) {
        return this.getNonNull().set(n2, e2);
    }

    @Override
    public void add(int n2, E e2) {
        this.getNonNull().add(n2, e2);
    }

    @Override
    public E remove(int n2) {
        return this.getNonNull().remove(n2);
    }

    @Override
    public int indexOf(Object object) {
        return this.getNonNull().indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.getNonNull().lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.getNonNull().listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int n2) {
        return this.getNonNull().listIterator(n2);
    }

    @Override
    public List<E> subList(int n2, int n3) {
        return this.getNonNull().subList(n2, n3);
    }

    @Override
    public boolean addAll(E ... EArray) {
        return this.getNonNull().addAll(EArray);
    }

    @Override
    public boolean setAll(E ... EArray) {
        return this.getNonNull().setAll(EArray);
    }

    @Override
    public boolean setAll(Collection<? extends E> collection) {
        return this.getNonNull().setAll(collection);
    }

    @Override
    public boolean removeAll(E ... EArray) {
        return this.getNonNull().removeAll(EArray);
    }

    @Override
    public boolean retainAll(E ... EArray) {
        return this.getNonNull().retainAll(EArray);
    }

    @Override
    public void remove(int n2, int n3) {
        this.getNonNull().remove(n2, n3);
    }

    private ObservableList<E> getNonNull() {
        ObservableList observableList = (ObservableList)this.get();
        if (observableList == null) {
            return FXCollections.emptyObservableList();
        }
        return observableList;
    }
}

