/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property;

import com.sun.javafx.binding.Logging;
import com.sun.javafx.logging.PlatformLogger;
import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty$1;
import javafx.beans.property.BooleanProperty$2;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.WritableBooleanValue;

public abstract class BooleanProperty
extends ReadOnlyBooleanProperty
implements Property<Boolean>,
WritableBooleanValue {
    @Override
    public void setValue(Boolean bl2) {
        if (bl2 == null) {
            ((PlatformLogger)Logging.getLogger()).fine("Attempt to set boolean property to null, using default value instead.", new NullPointerException());
            this.set(false);
            return;
        }
        this.set(bl2);
    }

    @Override
    public void bindBidirectional(Property<Boolean> property) {
        Bindings.bindBidirectional(this, property);
    }

    @Override
    public void unbindBidirectional(Property<Boolean> property) {
        Bindings.unbindBidirectional(this, property);
    }

    @Override
    public String toString() {
        Object object = this.getBean();
        String string = this.getName();
        StringBuilder stringBuilder = new StringBuilder("BooleanProperty [");
        if (object != null) {
            stringBuilder.append("bean: ").append(object).append(", ");
        }
        if (string != null && !string.equals("")) {
            stringBuilder.append("name: ").append(string).append(", ");
        }
        stringBuilder.append("value: ").append(this.get()).append("]");
        return stringBuilder.toString();
    }

    public static BooleanProperty booleanProperty(Property<Boolean> property) {
        Objects.requireNonNull(property, "Property cannot be null");
        if (property instanceof BooleanProperty) {
            return (BooleanProperty)property;
        }
        return new BooleanProperty$1(property);
    }

    @Override
    public ObjectProperty<Boolean> asObject() {
        return new BooleanProperty$2(this);
    }
}

