/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property;

import com.sun.javafx.binding.ExpressionHelper;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase$1;
import javafx.beans.property.DoublePropertyBase$2;
import javafx.beans.property.DoublePropertyBase$Listener;
import javafx.beans.property.DoublePropertyBase$ValueWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;

public abstract class DoublePropertyBase
extends DoubleProperty {
    private double value;
    private ObservableDoubleValue observable = null;
    private InvalidationListener listener = null;
    private boolean valid = true;
    private ExpressionHelper<Number> helper = null;

    public DoublePropertyBase() {
    }

    public DoublePropertyBase(double d2) {
        this.value = d2;
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        this.helper = ExpressionHelper.addListener(this.helper, this, invalidationListener);
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        this.helper = ExpressionHelper.removeListener(this.helper, invalidationListener);
    }

    @Override
    public void addListener(ChangeListener<? super Number> changeListener) {
        this.helper = ExpressionHelper.addListener(this.helper, this, changeListener);
    }

    @Override
    public void removeListener(ChangeListener<? super Number> changeListener) {
        this.helper = ExpressionHelper.removeListener(this.helper, changeListener);
    }

    protected void fireValueChangedEvent() {
        ExpressionHelper.fireValueChangedEvent(this.helper);
    }

    private void markInvalid() {
        if (this.valid) {
            this.valid = false;
            this.invalidated();
            this.fireValueChangedEvent();
        }
    }

    protected void invalidated() {
    }

    @Override
    public double get() {
        this.valid = true;
        if (this.observable == null) {
            return this.value;
        }
        return this.observable.get();
    }

    @Override
    public void set(double d2) {
        if (this.isBound()) {
            throw new RuntimeException((String)(this.getBean() != null && this.getName() != null ? this.getBean().getClass().getSimpleName() + "." + this.getName() + " : " : "") + "A bound value cannot be set.");
        }
        if (this.value != d2) {
            this.value = d2;
            this.markInvalid();
        }
    }

    @Override
    public boolean isBound() {
        return this.observable != null;
    }

    @Override
    public void bind(ObservableValue<? extends Number> observableDoubleValue) {
        if (observableDoubleValue == null) {
            throw new NullPointerException("Cannot bind to null");
        }
        if (observableDoubleValue instanceof ObservableDoubleValue) {
            observableDoubleValue = observableDoubleValue;
        } else if (observableDoubleValue instanceof ObservableNumberValue) {
            ObservableNumberValue observableNumberValue = observableDoubleValue;
            observableDoubleValue = new DoublePropertyBase$1(this, observableDoubleValue, observableNumberValue);
        } else {
            ObservableDoubleValue observableDoubleValue2 = observableDoubleValue;
            observableDoubleValue = new DoublePropertyBase$2(this, observableDoubleValue2, observableDoubleValue2);
        }
        if (!observableDoubleValue.equals(this.observable)) {
            this.unbind();
            this.observable = observableDoubleValue;
            if (this.listener == null) {
                this.listener = new DoublePropertyBase$Listener(this);
            }
            this.observable.addListener(this.listener);
            this.markInvalid();
        }
    }

    @Override
    public void unbind() {
        if (this.observable != null) {
            this.value = this.observable.get();
            this.observable.removeListener(this.listener);
            if (this.observable instanceof DoublePropertyBase$ValueWrapper) {
                ((DoubleBinding)((DoublePropertyBase$ValueWrapper)this.observable)).dispose();
            }
            this.observable = null;
        }
    }

    @Override
    public String toString() {
        Object object = this.getBean();
        String string = this.getName();
        StringBuilder stringBuilder = new StringBuilder("DoubleProperty [");
        if (object != null) {
            stringBuilder.append("bean: ").append(object).append(", ");
        }
        if (string != null && !string.equals("")) {
            stringBuilder.append("name: ").append(string).append(", ");
        }
        if (this.isBound()) {
            stringBuilder.append("bound, ");
            if (this.valid) {
                stringBuilder.append("value: ").append(this.get());
            } else {
                stringBuilder.append("invalid");
            }
        } else {
            stringBuilder.append("value: ").append(this.get());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

