/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property;

import com.sun.javafx.binding.Logging;
import com.sun.javafx.logging.PlatformLogger;
import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.property.FloatProperty$1;
import javafx.beans.property.FloatProperty$2;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyFloatProperty;
import javafx.beans.value.WritableFloatValue;

public abstract class FloatProperty
extends ReadOnlyFloatProperty
implements Property<Number>,
WritableFloatValue {
    @Override
    public void setValue(Number number) {
        if (number == null) {
            ((PlatformLogger)Logging.getLogger()).fine("Attempt to set float property to null, using default value instead.", new NullPointerException());
            this.set(0.0f);
            return;
        }
        this.set(number.floatValue());
    }

    @Override
    public void bindBidirectional(Property<Number> property) {
        Bindings.bindBidirectional(this, property);
    }

    @Override
    public void unbindBidirectional(Property<Number> property) {
        Bindings.unbindBidirectional(this, property);
    }

    @Override
    public String toString() {
        Object object = this.getBean();
        String string = this.getName();
        StringBuilder stringBuilder = new StringBuilder("FloatProperty [");
        if (object != null) {
            stringBuilder.append("bean: ").append(object).append(", ");
        }
        if (string != null && !string.equals("")) {
            stringBuilder.append("name: ").append(string).append(", ");
        }
        stringBuilder.append("value: ").append(this.get()).append("]");
        return stringBuilder.toString();
    }

    public static FloatProperty floatProperty(Property<Float> property) {
        Objects.requireNonNull(property, "Property cannot be null");
        return new FloatProperty$1(property);
    }

    @Override
    public ObjectProperty<Float> asObject() {
        return new FloatProperty$2(this);
    }
}

