/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.value;

import com.sun.javafx.binding.ConditionalBinding;
import com.sun.javafx.binding.FlatMappedBinding;
import com.sun.javafx.binding.MappedBinding;
import com.sun.javafx.binding.OrElseBinding;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.util.Subscription;

public interface ObservableValue<T>
extends Observable {
    public void addListener(ChangeListener<? super T> var1);

    public void removeListener(ChangeListener<? super T> var1);

    public T getValue();

    default public <U> ObservableValue<U> map(Function<? super T, ? extends U> function) {
        return new MappedBinding<T, U>(this, function);
    }

    default public ObservableValue<T> orElse(T t2) {
        return new OrElseBinding<T>(this, t2);
    }

    default public <U> ObservableValue<U> flatMap(Function<? super T, ? extends ObservableValue<? extends U>> function) {
        return new FlatMappedBinding(this, function);
    }

    default public ObservableValue<T> when(ObservableValue<Boolean> observableValue) {
        return new ConditionalBinding(this, observableValue);
    }

    default public Subscription subscribe(BiConsumer<? super T, ? super T> object3) {
        Objects.requireNonNull(object3, "changeSubscriber cannot be null");
        object3 = (observableValue, object, object2) -> object3.accept(object, object2);
        this.addListener((ChangeListener<? super T>)object3);
        return () -> this.lambda$subscribe$1((ChangeListener)object3);
    }

    default public Subscription subscribe(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer, "valueSubscriber cannot be null");
        ChangeListener<Object> changeListener = (observableValue, object, object2) -> consumer.accept(object2);
        consumer.accept(this.getValue());
        this.addListener(changeListener);
        return () -> this.removeListener(changeListener);
    }

    private /* synthetic */ void lambda$subscribe$1(ChangeListener changeListener) {
        this.removeListener(changeListener);
    }
}

