/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections;

import com.sun.javafx.collections.SourceAdapterChange;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javafx.collections.FXCollections$CheckedObservableList$1;
import javafx.collections.FXCollections$CheckedObservableList$2;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableListBase;
import javafx.collections.WeakListChangeListener;

class FXCollections$CheckedObservableList<T>
extends ObservableListBase<T> {
    private final ObservableList<T> list;
    private final Class<T> type;
    private final ListChangeListener<T> listener;

    FXCollections$CheckedObservableList(ObservableList<T> observableList, Class<T> clazz) {
        if (observableList == null || clazz == null) {
            throw new NullPointerException();
        }
        this.list = observableList;
        this.type = clazz;
        this.listener = listChangeListener$Change -> this.fireChange(new SourceAdapterChange(this, listChangeListener$Change));
        observableList.addListener(new WeakListChangeListener<T>(this.listener));
    }

    void typeCheck(Object object) {
        if (object != null && !this.type.isInstance(object)) {
            throw new ClassCastException("Attempt to insert " + String.valueOf(object.getClass()) + " element into collection with element type " + String.valueOf(this.type));
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.list.contains(object);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <X> X[] toArray(X[] XArray) {
        return this.list.toArray(XArray);
    }

    @Override
    public String toString() {
        return this.list.toString();
    }

    @Override
    public boolean remove(Object object) {
        return this.list.remove(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.list.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.list.retainAll(collection);
    }

    @Override
    public boolean removeAll(T ... TArray) {
        return this.list.removeAll(TArray);
    }

    @Override
    public boolean retainAll(T ... TArray) {
        return this.list.retainAll(TArray);
    }

    @Override
    public void remove(int n2, int n3) {
        this.list.remove(n2, n3);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean equals(Object object) {
        return object == this || this.list.equals(object);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public T get(int n2) {
        return (T)this.list.get(n2);
    }

    @Override
    public T remove(int n2) {
        return (T)this.list.remove(n2);
    }

    @Override
    public int indexOf(Object object) {
        return this.list.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.list.lastIndexOf(object);
    }

    @Override
    public T set(int n2, T t2) {
        this.typeCheck(t2);
        return this.list.set(n2, t2);
    }

    @Override
    public void add(int n2, T t2) {
        this.typeCheck(t2);
        this.list.add(n2, t2);
    }

    @Override
    public boolean addAll(int n2, Collection<? extends T> objectArray) {
        try {
            objectArray = objectArray.toArray((Object[])Array.newInstance(this.type, 0));
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new ClassCastException();
        }
        return this.list.addAll(n2, (Collection<T>)Arrays.asList(objectArray));
    }

    @Override
    public boolean addAll(Collection<? extends T> objectArray) {
        try {
            objectArray = objectArray.toArray((Object[])Array.newInstance(this.type, 0));
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new ClassCastException();
        }
        return this.list.addAll((Collection<T>)Arrays.asList(objectArray));
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(int n2) {
        return new FXCollections$CheckedObservableList$1(this, n2);
    }

    @Override
    public Iterator<T> iterator() {
        return new FXCollections$CheckedObservableList$2(this);
    }

    @Override
    public boolean add(T t2) {
        this.typeCheck(t2);
        return this.list.add(t2);
    }

    @Override
    public List<T> subList(int n2, int n3) {
        return Collections.checkedList(this.list.subList(n2, n3), this.type);
    }

    @Override
    public boolean addAll(T ... TArray) {
        try {
            Object[] objectArray = (Object[])Array.newInstance(this.type, TArray.length);
            System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
            return this.list.addAll(objectArray);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new ClassCastException();
        }
    }

    @Override
    public boolean setAll(T ... TArray) {
        try {
            Object[] objectArray = (Object[])Array.newInstance(this.type, TArray.length);
            System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
            return this.list.setAll(objectArray);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new ClassCastException();
        }
    }

    @Override
    public boolean setAll(Collection<? extends T> objectArray) {
        try {
            objectArray = objectArray.toArray((Object[])Array.newInstance(this.type, 0));
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new ClassCastException();
        }
        return this.list.setAll((Collection<T>)Arrays.asList(objectArray));
    }
}

