/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections;

import com.sun.javafx.collections.SetAdapterChange;
import com.sun.javafx.collections.SetListenerHelper;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javafx.beans.InvalidationListener;
import javafx.collections.FXCollections$CheckedObservableSet$1;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.collections.SetChangeListener$Change;
import javafx.collections.WeakSetChangeListener;

class FXCollections$CheckedObservableSet<E>
extends AbstractSet<E>
implements ObservableSet<E> {
    private final ObservableSet<E> backingSet;
    private final Class<E> type;
    private SetListenerHelper<E> listenerHelper;
    private final SetChangeListener<E> listener;

    FXCollections$CheckedObservableSet(ObservableSet<E> observableSet, Class<E> clazz) {
        if (observableSet == null || clazz == null) {
            throw new NullPointerException();
        }
        this.backingSet = observableSet;
        this.type = clazz;
        this.listener = setChangeListener$Change -> this.callObservers(new SetAdapterChange(this, setChangeListener$Change));
        this.backingSet.addListener(new WeakSetChangeListener<E>(this.listener));
    }

    private void callObservers(SetChangeListener$Change<? extends E> setChangeListener$Change) {
        SetListenerHelper.fireValueChangedEvent(this.listenerHelper, setChangeListener$Change);
    }

    void typeCheck(Object object) {
        if (object != null && !this.type.isInstance(object)) {
            throw new ClassCastException("Attempt to insert " + String.valueOf(object.getClass()) + " element into collection with element type " + String.valueOf(this.type));
        }
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        this.listenerHelper = SetListenerHelper.addListener(this.listenerHelper, invalidationListener);
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        this.listenerHelper = SetListenerHelper.removeListener(this.listenerHelper, invalidationListener);
    }

    @Override
    public void addListener(SetChangeListener<? super E> setChangeListener) {
        this.listenerHelper = SetListenerHelper.addListener(this.listenerHelper, setChangeListener);
    }

    @Override
    public void removeListener(SetChangeListener<? super E> setChangeListener) {
        this.listenerHelper = SetListenerHelper.removeListener(this.listenerHelper, setChangeListener);
    }

    @Override
    public int size() {
        return this.backingSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingSet.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.backingSet.contains(object);
    }

    @Override
    public Object[] toArray() {
        return this.backingSet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.backingSet.toArray(TArray);
    }

    @Override
    public boolean add(E e2) {
        this.typeCheck(e2);
        return this.backingSet.add(e2);
    }

    @Override
    public boolean remove(Object object) {
        return this.backingSet.remove(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.backingSet.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> objectArray) {
        try {
            objectArray = objectArray.toArray((Object[])Array.newInstance(this.type, 0));
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new ClassCastException();
        }
        return this.backingSet.addAll(Arrays.asList(objectArray));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.backingSet.retainAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.backingSet.removeAll(collection);
    }

    @Override
    public void clear() {
        this.backingSet.clear();
    }

    @Override
    public boolean equals(Object object) {
        return object == this || this.backingSet.equals(object);
    }

    @Override
    public int hashCode() {
        return this.backingSet.hashCode();
    }

    @Override
    public Iterator<E> iterator() {
        Iterator iterator = this.backingSet.iterator();
        return new FXCollections$CheckedObservableSet$1(this, iterator);
    }
}

