/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections;

import com.sun.javafx.collections.ObservableFloatArrayImpl;
import com.sun.javafx.collections.ObservableIntegerArrayImpl;
import com.sun.javafx.collections.ObservableListWrapper;
import com.sun.javafx.collections.ObservableMapWrapper;
import com.sun.javafx.collections.ObservableSequentialListWrapper;
import com.sun.javafx.collections.ObservableSetWrapper;
import com.sun.javafx.collections.SortableList;
import com.sun.javafx.collections.UnmodifiableObservableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import javafx.beans.Observable;
import javafx.collections.FXCollections$CheckedObservableList;
import javafx.collections.FXCollections$CheckedObservableMap;
import javafx.collections.FXCollections$CheckedObservableSet;
import javafx.collections.FXCollections$EmptyObservableList;
import javafx.collections.FXCollections$EmptyObservableMap;
import javafx.collections.FXCollections$EmptyObservableSet;
import javafx.collections.FXCollections$SingletonObservableList;
import javafx.collections.FXCollections$SynchronizedObservableList;
import javafx.collections.FXCollections$SynchronizedObservableMap;
import javafx.collections.FXCollections$SynchronizedObservableSet;
import javafx.collections.FXCollections$UnmodifiableObservableListImpl;
import javafx.collections.FXCollections$UnmodifiableObservableSet;
import javafx.collections.ObservableFloatArray;
import javafx.collections.ObservableIntegerArray;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.util.Callback;

public class FXCollections {
    private static final ObservableMap<?, ?> EMPTY_OBSERVABLE_MAP = new FXCollections$EmptyObservableMap();
    private static final ObservableList<?> EMPTY_OBSERVABLE_LIST = new FXCollections$EmptyObservableList();
    private static final ObservableSet<?> EMPTY_OBSERVABLE_SET = new FXCollections$EmptyObservableSet();
    private static Random r;

    private FXCollections() {
    }

    public static <E> ObservableList<E> observableList(List<E> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (list instanceof RandomAccess) {
            return new ObservableListWrapper<E>(list);
        }
        return new ObservableSequentialListWrapper<E>(list);
    }

    public static <E> ObservableList<E> observableList(List<E> list, Callback<E, Observable[]> callback) {
        if (list == null || callback == null) {
            throw new NullPointerException();
        }
        if (list instanceof RandomAccess) {
            return new ObservableListWrapper<E>(list, callback);
        }
        return new ObservableSequentialListWrapper<E>(list, callback);
    }

    public static <K, V> ObservableMap<K, V> observableMap(Map<K, V> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        return new ObservableMapWrapper<K, V>(map);
    }

    public static <E> ObservableSet<E> observableSet(Set<E> set) {
        if (set == null) {
            throw new NullPointerException();
        }
        return new ObservableSetWrapper<E>(set);
    }

    public static <E> ObservableSet<E> observableSet(E ... EArray) {
        if (EArray == null) {
            throw new NullPointerException();
        }
        HashSet hashSet = new HashSet(EArray.length);
        Collections.addAll(hashSet, EArray);
        return new ObservableSetWrapper(hashSet);
    }

    public static <K, V> ObservableMap<K, V> unmodifiableObservableMap(ObservableMap<K, V> observableMap) {
        if (observableMap == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableObservableMap<K, V>(observableMap);
    }

    public static <K, V> ObservableMap<K, V> checkedObservableMap(ObservableMap<K, V> observableMap, Class<K> clazz, Class<V> clazz2) {
        if (observableMap == null || clazz == null || clazz2 == null) {
            throw new NullPointerException();
        }
        return new FXCollections$CheckedObservableMap<K, V>(observableMap, clazz, clazz2);
    }

    public static <K, V> ObservableMap<K, V> synchronizedObservableMap(ObservableMap<K, V> observableMap) {
        if (observableMap == null) {
            throw new NullPointerException();
        }
        return new FXCollections$SynchronizedObservableMap<K, V>(observableMap);
    }

    public static <K, V> ObservableMap<K, V> emptyObservableMap() {
        return EMPTY_OBSERVABLE_MAP;
    }

    public static ObservableIntegerArray observableIntegerArray() {
        return new ObservableIntegerArrayImpl();
    }

    public static ObservableIntegerArray observableIntegerArray(int ... nArray) {
        return new ObservableIntegerArrayImpl(nArray);
    }

    public static ObservableIntegerArray observableIntegerArray(ObservableIntegerArray observableIntegerArray) {
        return new ObservableIntegerArrayImpl(observableIntegerArray);
    }

    public static ObservableFloatArray observableFloatArray() {
        return new ObservableFloatArrayImpl();
    }

    public static ObservableFloatArray observableFloatArray(float ... fArray) {
        return new ObservableFloatArrayImpl(fArray);
    }

    public static ObservableFloatArray observableFloatArray(ObservableFloatArray observableFloatArray) {
        return new ObservableFloatArrayImpl(observableFloatArray);
    }

    public static <E> ObservableList<E> observableArrayList() {
        return FXCollections.observableList(new ArrayList());
    }

    public static <E> ObservableList<E> observableArrayList(Callback<E, Observable[]> callback) {
        return FXCollections.observableList(new ArrayList(), callback);
    }

    public static <E> ObservableList<E> observableArrayList(E ... EArray) {
        return FXCollections.observableList(new ArrayList<E>(Arrays.asList(EArray)));
    }

    public static <E> ObservableList<E> observableArrayList(Collection<? extends E> collection) {
        return FXCollections.observableList(new ArrayList<E>(collection));
    }

    public static <K, V> ObservableMap<K, V> observableHashMap() {
        return FXCollections.observableMap(new HashMap());
    }

    public static <E> ObservableList<E> concat(ObservableList<E> ... observableListArray) {
        if (observableListArray.length == 0) {
            return FXCollections.observableArrayList();
        }
        if (observableListArray.length == 1) {
            return FXCollections.observableArrayList(observableListArray[0]);
        }
        ArrayList<E> arrayList = new ArrayList<E>();
        for (ObservableList<E> observableList : observableListArray) {
            arrayList.addAll(observableList);
        }
        return FXCollections.observableList(arrayList);
    }

    public static <E> ObservableList<E> unmodifiableObservableList(ObservableList<E> observableList) {
        if (observableList == null) {
            throw new NullPointerException();
        }
        return new FXCollections$UnmodifiableObservableListImpl<E>(observableList);
    }

    public static <E> ObservableList<E> checkedObservableList(ObservableList<E> observableList, Class<E> clazz) {
        if (observableList == null) {
            throw new NullPointerException();
        }
        return new FXCollections$CheckedObservableList<E>(observableList, clazz);
    }

    public static <E> ObservableList<E> synchronizedObservableList(ObservableList<E> observableList) {
        if (observableList == null) {
            throw new NullPointerException();
        }
        return new FXCollections$SynchronizedObservableList<E>(observableList);
    }

    public static <E> ObservableList<E> emptyObservableList() {
        return EMPTY_OBSERVABLE_LIST;
    }

    public static <E> ObservableList<E> singletonObservableList(E e2) {
        return new FXCollections$SingletonObservableList<E>(e2);
    }

    public static <E> ObservableSet<E> unmodifiableObservableSet(ObservableSet<E> observableSet) {
        if (observableSet == null) {
            throw new NullPointerException();
        }
        return new FXCollections$UnmodifiableObservableSet<E>(observableSet);
    }

    public static <E> ObservableSet<E> checkedObservableSet(ObservableSet<E> observableSet, Class<E> clazz) {
        if (observableSet == null) {
            throw new NullPointerException();
        }
        return new FXCollections$CheckedObservableSet<E>(observableSet, clazz);
    }

    public static <E> ObservableSet<E> synchronizedObservableSet(ObservableSet<E> observableSet) {
        if (observableSet == null) {
            throw new NullPointerException();
        }
        return new FXCollections$SynchronizedObservableSet<E>(observableSet);
    }

    public static <E> ObservableSet<E> emptyObservableSet() {
        return EMPTY_OBSERVABLE_SET;
    }

    public static <T> void copy(ObservableList<? super T> observableList, List<? extends T> list) {
        int n2 = list.size();
        if (n2 > observableList.size()) {
            throw new IndexOutOfBoundsException("Source does not fit in dest");
        }
        Object[] objectArray = observableList.toArray();
        System.arraycopy(list.toArray(), 0, objectArray, 0, n2);
        observableList.setAll(objectArray);
    }

    public static <T> void fill(ObservableList<? super T> observableList, T t2) {
        Object[] objectArray = new Object[observableList.size()];
        Arrays.fill(objectArray, t2);
        observableList.setAll(objectArray);
    }

    public static <T> boolean replaceAll(ObservableList<T> observableList, T t2, T t3) {
        Object[] objectArray = observableList.toArray();
        boolean bl2 = false;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (!objectArray[i2].equals(t2)) continue;
            objectArray[i2] = t3;
            bl2 = true;
        }
        if (bl2) {
            observableList.setAll(objectArray);
        }
        return bl2;
    }

    public static void reverse(ObservableList observableList) {
        Object[] objectArray = observableList.toArray();
        for (int i2 = 0; i2 < objectArray.length / 2; ++i2) {
            Object object = objectArray[i2];
            objectArray[i2] = objectArray[objectArray.length - i2 - 1];
            objectArray[objectArray.length - i2 - 1] = object;
        }
        observableList.setAll(objectArray);
    }

    public static void rotate(ObservableList observableList, int n2) {
        Object[] objectArray = observableList.toArray();
        int n3 = observableList.size();
        if ((n2 %= n3) < 0) {
            n2 += n3;
        }
        if (n2 == 0) {
            return;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 != n3) {
            Object object = objectArray[n4];
            int n6 = n4;
            do {
                if ((n6 += n2) >= n3) {
                    n6 -= n3;
                }
                Object object2 = objectArray[n6];
                objectArray[n6] = object;
                object = object2;
                ++n5;
            } while (n6 != n4);
            ++n4;
        }
        observableList.setAll(objectArray);
    }

    public static void shuffle(ObservableList<?> observableList) {
        if (r == null) {
            r = new Random();
        }
        FXCollections.shuffle(observableList, r);
    }

    public static void shuffle(ObservableList observableList, Random random) {
        Object[] objectArray = observableList.toArray();
        for (int i2 = observableList.size(); i2 > 1; --i2) {
            FXCollections.swap(objectArray, i2 - 1, random.nextInt(i2));
        }
        observableList.setAll(objectArray);
    }

    private static void swap(Object[] objectArray, int n2, int n3) {
        Object object = objectArray[n2];
        objectArray[n2] = objectArray[n3];
        objectArray[n3] = object;
    }

    public static <T extends Comparable<? super T>> void sort(ObservableList<T> observableList) {
        FXCollections.sort(observableList, Comparator.naturalOrder());
    }

    public static <T> void sort(ObservableList<T> observableList, Comparator<? super T> comparator) {
        if (observableList instanceof SortableList) {
            observableList.sort(comparator);
            return;
        }
        ArrayList<T> arrayList = new ArrayList<T>(observableList);
        arrayList.sort(comparator);
        observableList.setAll((Collection<T>)arrayList);
    }
}

