/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections;

import com.sun.javafx.collections.ChangeHelper;
import java.util.List;
import javafx.collections.ListChangeBuilder$SubChange;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableListBase;

class ListChangeBuilder$SingleChange<E>
extends ListChangeListener$Change<E> {
    private final ListChangeBuilder$SubChange<E> change;
    private boolean onChange;

    public ListChangeBuilder$SingleChange(ListChangeBuilder$SubChange<E> listChangeBuilder$SubChange, ObservableListBase<E> observableListBase) {
        super(observableListBase);
        this.change = listChangeBuilder$SubChange;
    }

    @Override
    public boolean next() {
        if (this.onChange) {
            return false;
        }
        this.onChange = true;
        return true;
    }

    @Override
    public void reset() {
        this.onChange = false;
    }

    @Override
    public int getFrom() {
        this.checkState();
        return this.change.from;
    }

    @Override
    public int getTo() {
        this.checkState();
        return this.change.to;
    }

    @Override
    public List<E> getRemoved() {
        this.checkState();
        return this.change.removed;
    }

    @Override
    protected int[] getPermutation() {
        this.checkState();
        return this.change.perm;
    }

    @Override
    public boolean wasUpdated() {
        this.checkState();
        return this.change.updated;
    }

    private void checkState() {
        if (!this.onChange) {
            throw new IllegalStateException("Invalid Change state: next() must be called before inspecting the Change.");
        }
    }

    public String toString() {
        String string = this.change.perm.length != 0 ? ChangeHelper.permChangeToString(this.change.perm) : (this.change.updated ? ChangeHelper.updateChangeToString(this.change.from, this.change.to) : ChangeHelper.addRemoveChangeToString(this.change.from, this.change.to, this.getList(), this.change.removed));
        return "{ " + string + " }";
    }
}

