/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections;

import java.lang.ref.WeakReference;
import javafx.beans.NamedArg;
import javafx.beans.WeakListener;
import javafx.collections.SetChangeListener;
import javafx.collections.SetChangeListener$Change;

public final class WeakSetChangeListener<E>
implements WeakListener,
SetChangeListener<E> {
    private final WeakReference<SetChangeListener<E>> ref;

    public WeakSetChangeListener(@NamedArg(value="listener") SetChangeListener<E> setChangeListener) {
        if (setChangeListener == null) {
            throw new NullPointerException("Listener must be specified.");
        }
        this.ref = new WeakReference<SetChangeListener<E>>(setChangeListener);
    }

    @Override
    public final boolean wasGarbageCollected() {
        return this.ref.get() == null;
    }

    @Override
    public final void onChanged(SetChangeListener$Change<? extends E> setChangeListener$Change) {
        SetChangeListener setChangeListener = (SetChangeListener)this.ref.get();
        if (setChangeListener != null) {
            setChangeListener.onChanged(setChangeListener$Change);
            return;
        }
        setChangeListener$Change.getSet().removeListener(this);
    }
}

