/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections.transformation;

import com.sun.javafx.collections.NonIterableChange$GenericAddRemoveChange;
import com.sun.javafx.collections.SortHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.function.Predicate;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList$1;
import javafx.collections.transformation.TransformationList;

public final class FilteredList<E>
extends TransformationList<E, E> {
    private int[] filtered;
    private int size;
    private SortHelper helper;
    private ObjectProperty<Predicate<? super E>> predicate;

    public FilteredList(@NamedArg(value="source") ObservableList<E> observableList, @NamedArg(value="predicate") Predicate<? super E> predicate) {
        super(observableList);
        this.filtered = new int[observableList.size() * 3 / 2 + 1];
        if (predicate != null) {
            this.setPredicate(predicate);
            return;
        }
        this.size = 0;
        while (this.size < observableList.size()) {
            this.filtered[this.size] = this.size;
            ++this.size;
        }
    }

    public FilteredList(@NamedArg(value="source") ObservableList<E> observableList) {
        this(observableList, null);
    }

    public final ObjectProperty<Predicate<? super E>> predicateProperty() {
        if (this.predicate == null) {
            this.predicate = new FilteredList$1(this);
        }
        return this.predicate;
    }

    public final Predicate<? super E> getPredicate() {
        if (this.predicate == null) {
            return null;
        }
        return (Predicate)this.predicate.get();
    }

    public final void setPredicate(Predicate<? super E> predicate) {
        this.predicateProperty().set(predicate);
    }

    private Predicate<? super E> getPredicateImpl() {
        if (this.getPredicate() != null) {
            return this.getPredicate();
        }
        return object -> true;
    }

    @Override
    protected final void sourceChanged(ListChangeListener$Change<? extends E> listChangeListener$Change) {
        this.beginChange();
        while (listChangeListener$Change.next()) {
            if (listChangeListener$Change.wasPermutated()) {
                this.permutate(listChangeListener$Change);
                continue;
            }
            if (listChangeListener$Change.wasUpdated()) {
                this.update(listChangeListener$Change);
                continue;
            }
            this.addRemove(listChangeListener$Change);
        }
        this.endChange();
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final E get(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.getSource().get(this.filtered[n2]);
    }

    @Override
    public final int getSourceIndex(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.filtered[n2];
    }

    @Override
    public final int getViewIndex(int n2) {
        return Arrays.binarySearch(this.filtered, 0, this.size, n2);
    }

    private SortHelper getSortHelper() {
        if (this.helper == null) {
            this.helper = new SortHelper();
        }
        return this.helper;
    }

    private int findPosition(int n2) {
        if (this.filtered.length == 0) {
            return 0;
        }
        if (n2 == 0) {
            return 0;
        }
        if ((n2 = Arrays.binarySearch(this.filtered, 0, this.size, n2)) < 0) {
            n2 ^= 0xFFFFFFFF;
        }
        return n2;
    }

    private void ensureSize(int n2) {
        if (this.filtered.length < n2) {
            int[] nArray = new int[n2 * 3 / 2 + 1];
            System.arraycopy(this.filtered, 0, nArray, 0, this.size);
            this.filtered = nArray;
        }
    }

    private void updateIndexes(int n2, int n3) {
        while (n2 < this.size) {
            int n4 = n2++;
            this.filtered[n4] = this.filtered[n4] + n3;
        }
    }

    private void permutate(ListChangeListener$Change<? extends E> listChangeListener$Change) {
        int n2 = this.findPosition(listChangeListener$Change.getFrom());
        int n3 = this.findPosition(listChangeListener$Change.getTo());
        if (n3 > n2) {
            for (int i2 = n2; i2 < n3; ++i2) {
                this.filtered[i2] = listChangeListener$Change.getPermutation(this.filtered[i2]);
            }
            int[] nArray = this.getSortHelper().sort(this.filtered, n2, n3);
            this.nextPermutation(n2, n3, nArray);
        }
    }

    private void addRemove(ListChangeListener$Change<? extends E> listChangeListener$Change) {
        int n2;
        Predicate<E> predicate = this.getPredicateImpl();
        FilteredList filteredList = this;
        filteredList.ensureSize(filteredList.getSource().size());
        int n3 = this.findPosition(listChangeListener$Change.getFrom());
        int n4 = this.findPosition(listChangeListener$Change.getFrom() + listChangeListener$Change.getRemovedSize());
        for (n2 = n3; n2 < n4; ++n2) {
            this.nextRemove(n3, listChangeListener$Change.getRemoved().get(this.filtered[n2] - listChangeListener$Change.getFrom()));
        }
        this.updateIndexes(n4, listChangeListener$Change.getAddedSize() - listChangeListener$Change.getRemovedSize());
        n2 = n3;
        n3 = listChangeListener$Change.getFrom();
        ListIterator listIterator = this.getSource().listIterator(n3);
        while (n2 < n4 && listIterator.nextIndex() < listChangeListener$Change.getTo()) {
            if (!predicate.test(listIterator.next())) continue;
            this.filtered[n2] = listIterator.previousIndex();
            int n5 = n2++;
            this.nextAdd(n5, n5 + 1);
        }
        if (n2 < n4) {
            System.arraycopy(this.filtered, n4, this.filtered, n2, this.size - n4);
            this.size -= n4 - n2;
            return;
        }
        while (listIterator.nextIndex() < listChangeListener$Change.getTo()) {
            if (!predicate.test(listIterator.next())) continue;
            System.arraycopy(this.filtered, n2, this.filtered, n2 + 1, this.size - n2);
            this.filtered[n2] = listIterator.previousIndex();
            int n6 = n2++;
            this.nextAdd(n6, n6 + 1);
            ++this.size;
        }
    }

    private void update(ListChangeListener$Change<? extends E> listChangeListener$Change) {
        int n2;
        Predicate<E> predicate = this.getPredicateImpl();
        FilteredList filteredList = this;
        filteredList.ensureSize(filteredList.getSource().size());
        int n3 = listChangeListener$Change.getTo();
        int n4 = this.findPosition(n2);
        int n5 = this.findPosition(n3);
        ListIterator listIterator = this.getSource().listIterator(n2);
        for (n2 = listChangeListener$Change.getFrom(); n4 < n5 || n2 < n3; ++n2) {
            Object e2 = listIterator.next();
            if (n4 < this.size && this.filtered[n4] == n2) {
                if (!predicate.test(e2)) {
                    this.nextRemove(n4, e2);
                    System.arraycopy(this.filtered, n4 + 1, this.filtered, n4, this.size - n4 - 1);
                    --this.size;
                    --n5;
                    continue;
                }
                this.nextUpdate(n4);
                ++n4;
                continue;
            }
            if (!predicate.test(e2)) continue;
            int n6 = n4;
            this.nextAdd(n6, n6 + 1);
            System.arraycopy(this.filtered, n4, this.filtered, n4 + 1, this.size - n4);
            this.filtered[n4] = n2;
            ++this.size;
            ++n4;
            ++n5;
        }
    }

    private void refilter() {
        FilteredList filteredList = this;
        filteredList.ensureSize(filteredList.getSource().size());
        ArrayList arrayList = null;
        if (this.hasListeners()) {
            arrayList = new ArrayList(this);
        }
        this.size = 0;
        int n2 = 0;
        Predicate<E> predicate = this.getPredicateImpl();
        for (Object e2 : this.getSource()) {
            if (predicate.test(e2)) {
                this.filtered[this.size++] = n2;
            }
            ++n2;
        }
        if (this.hasListeners()) {
            this.fireChange(new NonIterableChange$GenericAddRemoveChange(0, this.size, arrayList, this));
        }
    }
}

