/*
 * Decompiled with CFR 0.152.
 */
package javafx.concurrent;

import com.sun.javafx.event.EventHandlerManager;
import javafx.beans.property.ObjectProperty;
import javafx.concurrent.EventHelper$1;
import javafx.concurrent.EventHelper$2;
import javafx.concurrent.EventHelper$3;
import javafx.concurrent.EventHelper$4;
import javafx.concurrent.EventHelper$5;
import javafx.concurrent.EventHelper$6;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;

class EventHelper {
    private final EventTarget target;
    private final ObjectProperty<EventHandler<WorkerStateEvent>> onReady;
    private final ObjectProperty<EventHandler<WorkerStateEvent>> onScheduled;
    private final ObjectProperty<EventHandler<WorkerStateEvent>> onRunning;
    private final ObjectProperty<EventHandler<WorkerStateEvent>> onSucceeded;
    private final ObjectProperty<EventHandler<WorkerStateEvent>> onCancelled;
    private final ObjectProperty<EventHandler<WorkerStateEvent>> onFailed;
    private EventHandlerManager internalEventDispatcher;

    final ObjectProperty<EventHandler<WorkerStateEvent>> onReadyProperty() {
        return this.onReady;
    }

    final EventHandler<WorkerStateEvent> getOnReady() {
        return (EventHandler)this.onReady.get();
    }

    final void setOnReady(EventHandler<WorkerStateEvent> eventHandler) {
        this.onReady.set(eventHandler);
    }

    final ObjectProperty<EventHandler<WorkerStateEvent>> onScheduledProperty() {
        return this.onScheduled;
    }

    final EventHandler<WorkerStateEvent> getOnScheduled() {
        return (EventHandler)this.onScheduled.get();
    }

    final void setOnScheduled(EventHandler<WorkerStateEvent> eventHandler) {
        this.onScheduled.set(eventHandler);
    }

    final ObjectProperty<EventHandler<WorkerStateEvent>> onRunningProperty() {
        return this.onRunning;
    }

    final EventHandler<WorkerStateEvent> getOnRunning() {
        return (EventHandler)this.onRunning.get();
    }

    final void setOnRunning(EventHandler<WorkerStateEvent> eventHandler) {
        this.onRunning.set(eventHandler);
    }

    final ObjectProperty<EventHandler<WorkerStateEvent>> onSucceededProperty() {
        return this.onSucceeded;
    }

    final EventHandler<WorkerStateEvent> getOnSucceeded() {
        return (EventHandler)this.onSucceeded.get();
    }

    final void setOnSucceeded(EventHandler<WorkerStateEvent> eventHandler) {
        this.onSucceeded.set(eventHandler);
    }

    final ObjectProperty<EventHandler<WorkerStateEvent>> onCancelledProperty() {
        return this.onCancelled;
    }

    final EventHandler<WorkerStateEvent> getOnCancelled() {
        return (EventHandler)this.onCancelled.get();
    }

    final void setOnCancelled(EventHandler<WorkerStateEvent> eventHandler) {
        this.onCancelled.set(eventHandler);
    }

    final ObjectProperty<EventHandler<WorkerStateEvent>> onFailedProperty() {
        return this.onFailed;
    }

    final EventHandler<WorkerStateEvent> getOnFailed() {
        return (EventHandler)this.onFailed.get();
    }

    final void setOnFailed(EventHandler<WorkerStateEvent> eventHandler) {
        this.onFailed.set(eventHandler);
    }

    EventHelper(EventTarget eventTarget) {
        this.target = eventTarget;
        this.onReady = new EventHelper$1(this, eventTarget, "onReady");
        this.onScheduled = new EventHelper$2(this, eventTarget, "onScheduled");
        this.onRunning = new EventHelper$3(this, eventTarget, "onRunning");
        this.onSucceeded = new EventHelper$4(this, eventTarget, "onSucceeded");
        this.onCancelled = new EventHelper$5(this, eventTarget, "onCancelled");
        this.onFailed = new EventHelper$6(this, eventTarget, "onFailed");
    }

    final <T extends Event> void addEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().addEventHandler(eventType, eventHandler);
    }

    final <T extends Event> void removeEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().removeEventHandler(eventType, eventHandler);
    }

    final <T extends Event> void addEventFilter(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().addEventFilter(eventType, eventHandler);
    }

    final <T extends Event> void removeEventFilter(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().removeEventFilter(eventType, eventHandler);
    }

    final <T extends Event> void setEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().setEventHandler(eventType, eventHandler);
    }

    private EventHandlerManager getInternalEventDispatcher() {
        if (this.internalEventDispatcher == null) {
            this.internalEventDispatcher = new EventHandlerManager(this.target);
        }
        return this.internalEventDispatcher;
    }

    final void fireEvent(Event event) {
        Event.fireEvent(this.target, event);
    }

    EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
        if (this.internalEventDispatcher == null) {
            return eventDispatchChain;
        }
        return eventDispatchChain.append(this.getInternalEventDispatcher());
    }
}

