/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.ParsedValueImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javafx.css.ParsedValue;
import javafx.css.Rule;
import javafx.css.StyleConverter$StringStore;
import javafx.css.StyleOrigin;
import javafx.css.converter.URLConverter;
import javafx.css.converter.URLConverter$SequenceConverter;

public final class Declaration {
    final String property;
    final ParsedValue parsedValue;
    final boolean important;
    Rule rule;

    Declaration(String string, ParsedValue parsedValue, boolean bl2) {
        this.property = string;
        this.parsedValue = parsedValue;
        this.important = bl2;
        if (string == null) {
            throw new IllegalArgumentException("propertyName cannot be null");
        }
        if (parsedValue == null) {
            throw new IllegalArgumentException("parsedValue cannot be null");
        }
    }

    public final ParsedValue getParsedValue() {
        return this.parsedValue;
    }

    public final String getProperty() {
        return this.property;
    }

    public final Rule getRule() {
        return this.rule;
    }

    public final boolean isImportant() {
        return this.important;
    }

    private StyleOrigin getOrigin() {
        Rule rule = this.getRule();
        if (rule != null) {
            return rule.getOrigin();
        }
        return null;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Declaration)object;
        if (this.important != ((Declaration)object).important) {
            return false;
        }
        if (this.getOrigin() != ((Declaration)object).getOrigin()) {
            return false;
        }
        if (this.property == null ? ((Declaration)object).property != null : !this.property.equals(((Declaration)object).property)) {
            return false;
        }
        return this.parsedValue == ((Declaration)object).parsedValue || this.parsedValue != null && this.parsedValue.equals(((Declaration)object).parsedValue);
    }

    public final int hashCode() {
        int n2 = 445 + (this.property != null ? this.property.hashCode() : 0);
        n2 = n2 * 89 + (this.parsedValue != null ? this.parsedValue.hashCode() : 0);
        n2 = n2 * 89 + (this.important ? 1 : 0);
        return n2;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.property);
        stringBuilder.append(": ");
        stringBuilder.append(this.parsedValue);
        if (this.important) {
            stringBuilder.append(" !important");
        }
        return stringBuilder.toString();
    }

    final void fixUrl(String string) {
        if (string == null) {
            return;
        }
        ParsedValue[] parsedValueArray = this.parsedValue.getConverter();
        if (parsedValueArray == URLConverter.getInstance()) {
            ParsedValue[] parsedValueArray2 = (ParsedValue[])this.parsedValue.getValue();
            parsedValueArray = parsedValueArray2;
            parsedValueArray2[1] = new ParsedValueImpl(string, null);
            return;
        }
        if (parsedValueArray == URLConverter$SequenceConverter.getInstance()) {
            parsedValueArray = (ParsedValue[])this.parsedValue.getValue();
            for (int i2 = 0; i2 < parsedValueArray.length; ++i2) {
                ParsedValue[] parsedValueArray3 = (ParsedValue[])parsedValueArray[i2].getValue();
                ParsedValue[] parsedValueArray4 = parsedValueArray3;
                parsedValueArray3[1] = new ParsedValueImpl(string, null);
            }
        }
    }

    final void writeBinary(DataOutputStream dataOutputStream, StyleConverter$StringStore styleConverter$StringStore) throws IOException {
        if (this.parsedValue instanceof ParsedValueImpl) {
            dataOutputStream.writeShort(styleConverter$StringStore.addString(this.getProperty()));
            ((ParsedValueImpl)this.parsedValue).writeBinary(dataOutputStream, styleConverter$StringStore);
            dataOutputStream.writeBoolean(this.isImportant());
        }
    }

    static Declaration readBinary(int n2, DataInputStream dataInputStream, String[] stringArray) throws IOException {
        String string = stringArray[dataInputStream.readShort()];
        ParsedValueImpl parsedValueImpl = ParsedValueImpl.readBinary(n2, dataInputStream, stringArray);
        boolean bl2 = dataInputStream.readBoolean();
        return new Declaration(string, parsedValueImpl, bl2);
    }
}

