/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javafx.css.PseudoClass;
import javafx.css.Selector;
import javafx.css.SimpleSelector;
import javafx.geometry.NodeOrientation;

public final class Match
implements Comparable<Match> {
    private final Selector selector;
    private final Set<PseudoClass> pseudoClasses;
    final int styleClassCount;
    final int idCount;
    final int specificity;

    Match(Selector selector, Set<PseudoClass> set, int n2, int n3) {
        Objects.requireNonNull(selector);
        Objects.requireNonNull(set);
        this.selector = selector;
        this.idCount = n2;
        this.styleClassCount = n3;
        this.pseudoClasses = Collections.unmodifiableSet(set);
        int n4 = set.size();
        if (selector instanceof SimpleSelector && ((SimpleSelector)(selector = (SimpleSelector)selector)).getNodeOrientation() != NodeOrientation.INHERIT) {
            ++n4;
        }
        this.specificity = n2 << 8 | n3 << 4 | n4;
    }

    public final Selector getSelector() {
        return this.selector;
    }

    public final Set<PseudoClass> getPseudoClasses() {
        return this.pseudoClasses;
    }

    public final int getSpecificity() {
        return this.specificity;
    }

    @Override
    public final int compareTo(Match match) {
        return this.specificity - match.specificity;
    }
}

