/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.css.Declaration;
import javafx.css.PseudoClass;
import javafx.css.Rule$Observables;
import javafx.css.Selector;
import javafx.css.StyleConverter$StringStore;
import javafx.css.StyleOrigin;
import javafx.css.Stylesheet;
import javafx.scene.Node;

public final class Rule {
    private List<Selector> selectors = null;
    private List<Declaration> declarations = null;
    private Rule$Observables observables = null;
    private Stylesheet stylesheet;
    private byte[] serializedDecls;
    private final int bssVersion;

    final List<Selector> getUnobservedSelectorList() {
        if (this.selectors == null) {
            this.selectors = new ArrayList<Selector>();
        }
        return this.selectors;
    }

    final List<Declaration> getUnobservedDeclarationList() {
        if (this.declarations == null && this.serializedDecls != null) {
            try {
                InputStream inputStream = new ByteArrayInputStream(this.serializedDecls);
                inputStream = new DataInputStream(inputStream);
                int n2 = ((DataInputStream)inputStream).readShort();
                this.declarations = new ArrayList<Declaration>(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    Declaration declaration = Declaration.readBinary(this.bssVersion, (DataInputStream)inputStream, this.stylesheet.getStringStore());
                    Declaration.readBinary(this.bssVersion, (DataInputStream)inputStream, this.stylesheet.getStringStore()).rule = this;
                    if (this.stylesheet != null && this.stylesheet.getUrl() != null) {
                        String string = this.stylesheet.getUrl();
                        declaration.fixUrl(string);
                    }
                    this.declarations.add(declaration);
                }
            }
            catch (IOException iOException) {
                this.declarations = new ArrayList<Declaration>();
                assert (false);
                iOException.getMessage();
            }
            finally {
                this.serializedDecls = null;
            }
        }
        return this.declarations;
    }

    public final ObservableList<Declaration> getDeclarations() {
        if (this.observables == null) {
            this.observables = new Rule$Observables(this);
        }
        return this.observables.getDeclarations();
    }

    public final ObservableList<Selector> getSelectors() {
        if (this.observables == null) {
            this.observables = new Rule$Observables(this);
        }
        return this.observables.getSelectors();
    }

    public final Stylesheet getStylesheet() {
        return this.stylesheet;
    }

    final void setStylesheet(Stylesheet object) {
        this.stylesheet = object;
        if (object != null && ((Stylesheet)object).getUrl() != null) {
            object = ((Stylesheet)object).getUrl();
            int n2 = this.declarations != null ? this.declarations.size() : 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.declarations.get(i2).fixUrl((String)object);
            }
        }
    }

    public final StyleOrigin getOrigin() {
        if (this.stylesheet != null) {
            return this.stylesheet.getOrigin();
        }
        return null;
    }

    Rule(List<Selector> object, List<Declaration> list) {
        int n2;
        this.selectors = object;
        this.declarations = list;
        this.serializedDecls = null;
        this.bssVersion = 6;
        int n3 = object != null ? object.size() : 0;
        for (n2 = 0; n2 < n3; ++n2) {
            Selector selector = object.get(n2);
            selector.setRule(this);
        }
        n2 = list != null ? list.size() : 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            object = list.get(i2);
            list.get(i2).rule = this;
        }
    }

    private Rule(List<Selector> list, byte[] byArray, int n2) {
        this.selectors = list;
        this.declarations = null;
        this.serializedDecls = byArray;
        this.bssVersion = n2;
        int n3 = list != null ? list.size() : 0;
        for (n2 = 0; n2 < n3; ++n2) {
            Selector selector = list.get(n2);
            selector.setRule(this);
        }
    }

    final long applies(Node node, Set<PseudoClass>[] setArray) {
        long l2 = 0L;
        for (int i2 = 0; i2 < this.selectors.size(); ++i2) {
            Selector selector = this.selectors.get(i2);
            if (!selector.applies(node, setArray, 0)) continue;
            l2 |= 1L << i2;
        }
        return l2;
    }

    public final String toString() {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.selectors.size() > 0) {
            stringBuilder.append(this.selectors.get(0));
        }
        for (n2 = 1; n2 < this.selectors.size(); ++n2) {
            stringBuilder.append(',');
            stringBuilder.append(this.selectors.get(n2));
        }
        stringBuilder.append("{\n");
        n2 = this.declarations != null ? this.declarations.size() : 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append("\t");
            stringBuilder.append(this.declarations.get(i2));
            stringBuilder.append("\n");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    final void writeBinary(DataOutputStream dataOutputStream, StyleConverter$StringStore styleConverter$StringStore) throws IOException {
        Object object;
        int n2 = this.selectors != null ? this.selectors.size() : 0;
        dataOutputStream.writeShort(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            object = this.selectors.get(i2);
            ((Selector)object).writeBinary(dataOutputStream, styleConverter$StringStore);
        }
        List<Declaration> list = this.getUnobservedDeclarationList();
        if (list != null) {
            object = new ByteArrayOutputStream(5192);
            DataOutputStream dataOutputStream2 = new DataOutputStream((OutputStream)object);
            int n3 = list.size();
            dataOutputStream2.writeShort(n3);
            for (int i3 = 0; i3 < n3; ++i3) {
                Declaration declaration = this.declarations.get(i3);
                declaration.writeBinary(dataOutputStream2, styleConverter$StringStore);
            }
            dataOutputStream.writeInt(((ByteArrayOutputStream)object).size());
            dataOutputStream.write(((ByteArrayOutputStream)object).toByteArray());
            return;
        }
        dataOutputStream.writeShort(0);
    }

    static Rule readBinary(int n2, DataInputStream dataInputStream, String[] stringArray) throws IOException {
        ArrayList<Declaration> arrayList;
        int n3;
        int n4 = dataInputStream.readShort();
        ArrayList<Selector> arrayList2 = new ArrayList<Selector>(n4);
        for (n3 = 0; n3 < n4; ++n3) {
            arrayList = Selector.readBinary(n2, dataInputStream, stringArray);
            arrayList2.add((Selector)((Object)arrayList));
        }
        if (n2 < 4) {
            n3 = dataInputStream.readShort();
            arrayList = new ArrayList<Declaration>(n3);
            for (n4 = 0; n4 < n3; ++n4) {
                Declaration declaration = Declaration.readBinary(n2, dataInputStream, stringArray);
                arrayList.add(declaration);
            }
            return new Rule(arrayList2, arrayList);
        }
        n3 = dataInputStream.readInt();
        arrayList = (ArrayList<Declaration>)new byte[n3];
        if (n3 > 0) {
            dataInputStream.readFully((byte[])arrayList);
        }
        return new Rule((List<Selector>)arrayList2, (byte[])arrayList, n2);
    }
}

