/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.PseudoClassState;
import com.sun.javafx.css.StyleClassSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.css.Match;
import javafx.css.PseudoClass;
import javafx.css.Selector;
import javafx.css.StyleClass;
import javafx.css.StyleConverter$StringStore;
import javafx.css.Styleable;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;

public final class SimpleSelector
extends Selector {
    private final String name;
    private final Set<StyleClass> styleClassSet;
    private final Set<StyleClass> unwrappedStyleClassSet;
    private final String id;
    private final Set<PseudoClass> pseudoClassState;
    private final boolean matchOnName;
    private final boolean matchOnId;
    private final boolean matchOnStyleClass;
    private final NodeOrientation nodeOrientation;

    public final String getName() {
        return this.name;
    }

    public final List<String> getStyleClasses() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<StyleClass> iterator = this.styleClassSet.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().getStyleClassName());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public final Set<StyleClass> getStyleClassSet() {
        return this.styleClassSet;
    }

    public final String getId() {
        return this.id;
    }

    final Set<PseudoClass> getPseudoClassStates() {
        return this.pseudoClassState;
    }

    public final NodeOrientation getNodeOrientation() {
        return this.nodeOrientation;
    }

    SimpleSelector(String object, List<String> list, List<String> list2, String string) {
        Object object2;
        this.name = object == null ? "*" : object;
        this.matchOnName = object != null && !"".equals(object) && !"*".equals(object);
        this.unwrappedStyleClassSet = new StyleClassSet();
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                object2 = list.get(i2);
                if (object2 == null || object2.isEmpty()) continue;
                this.unwrappedStyleClassSet.add(StyleClassSet.getStyleClass(object2));
            }
        }
        this.styleClassSet = Collections.unmodifiableSet(this.unwrappedStyleClassSet);
        this.matchOnStyleClass = this.styleClassSet.size() > 0;
        object = new PseudoClassState();
        object2 = NodeOrientation.INHERIT;
        if (list2 != null) {
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                String string2 = list2.get(i3);
                if (string2 == null || string2.isEmpty()) continue;
                if ("dir(".regionMatches(true, 0, string2, 0, 4)) {
                    boolean bl2 = "dir(rtl)".equalsIgnoreCase(string2);
                    object2 = bl2 ? NodeOrientation.RIGHT_TO_LEFT : NodeOrientation.LEFT_TO_RIGHT;
                    continue;
                }
                ((PseudoClassState)object).add(PseudoClassState.getPseudoClass(string2));
            }
        }
        this.pseudoClassState = Collections.unmodifiableSet(object);
        this.nodeOrientation = object2;
        this.id = string == null ? "" : string;
        this.matchOnId = string != null && !"".equals(string);
    }

    @Override
    public final Match createMatch() {
        int n2 = this.matchOnId ? 1 : 0;
        int n3 = this.styleClassSet.size();
        SimpleSelector simpleSelector = this;
        return new Match(simpleSelector, simpleSelector.pseudoClassState, n2, n3);
    }

    @Override
    public final boolean applies(Styleable styleable) {
        boolean bl2;
        boolean bl3;
        Object object;
        Object object2;
        if (this.nodeOrientation != NodeOrientation.INHERIT && styleable instanceof Node && ((object2 = ((Node)(object = (Node)styleable)).getNodeOrientation()) == NodeOrientation.INHERIT ? ((Node)object).getEffectiveNodeOrientation() != this.nodeOrientation : object2 != this.nodeOrientation)) {
            return false;
        }
        if (this.matchOnId && !(bl3 = this.id.equals(object = styleable.getId()))) {
            return false;
        }
        if (this.matchOnName && !(bl2 = this.name.equals(object = styleable.getTypeSelector()))) {
            return false;
        }
        if (this.matchOnStyleClass) {
            int n2;
            object = new StyleClassSet();
            object2 = styleable.getStyleClass();
            int n3 = object2.size();
            for (n2 = 0; n2 < n3; ++n2) {
                Object object3 = (String)object2.get(n2);
                if (object3 == null || ((String)object3).isEmpty()) continue;
                object3 = StyleClassSet.getStyleClass((String)object3);
                ((StyleClassSet)object).add(object3);
            }
            boolean bl4 = this.matchStyleClasses((StyleClassSet)object);
            n2 = bl4 ? 1 : 0;
            if (!bl4) {
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean applies(Styleable styleable, Set<PseudoClass>[] setArray, int n2) {
        boolean bl2 = ((Selector)this).applies(styleable);
        if (bl2 && setArray != null && n2 < setArray.length) {
            if (setArray[n2] == null) {
                setArray[n2] = new PseudoClassState();
            }
            setArray[n2].addAll(this.pseudoClassState);
        }
        return bl2;
    }

    @Override
    public final boolean stateMatches(Styleable styleable, Set<PseudoClass> set) {
        if (set != null) {
            return set.containsAll(this.pseudoClassState);
        }
        return false;
    }

    private boolean matchStyleClasses(StyleClassSet styleClassSet) {
        return styleClassSet.containsAll(this.unwrappedStyleClassSet);
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (SimpleSelector)object;
        if (this.name == null ? ((SimpleSelector)object).name != null : !this.name.equals(((SimpleSelector)object).name)) {
            return false;
        }
        if (this.id == null ? ((SimpleSelector)object).id != null : !this.id.equals(((SimpleSelector)object).id)) {
            return false;
        }
        if (!this.styleClassSet.equals(((SimpleSelector)object).styleClassSet)) {
            return false;
        }
        return this.pseudoClassState.equals(((SimpleSelector)object).pseudoClassState);
    }

    public final int hashCode() {
        int n2 = 31 * (7 + this.name.hashCode());
        n2 = 31 * (n2 + this.styleClassSet.hashCode());
        n2 = 31 * (n2 + this.styleClassSet.hashCode());
        n2 = this.id != null ? 31 * (n2 + this.id.hashCode()) : 0;
        n2 = 31 * (n2 + this.pseudoClassState.hashCode());
        return n2;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.name != null && !this.name.isEmpty()) {
            stringBuilder.append(this.name);
        } else {
            stringBuilder.append("*");
        }
        for (StyleClass styleClass : this.styleClassSet) {
            stringBuilder.append('.').append(styleClass.getStyleClassName());
        }
        if (this.id != null && !this.id.isEmpty()) {
            stringBuilder.append('#');
            stringBuilder.append(this.id);
        }
        for (PseudoClass pseudoClass : this.pseudoClassState) {
            stringBuilder.append(':').append(pseudoClass.getPseudoClassName());
        }
        return stringBuilder.toString();
    }

    @Override
    protected final void writeBinary(DataOutputStream dataOutputStream, StyleConverter$StringStore styleConverter$StringStore) throws IOException {
        super.writeBinary(dataOutputStream, styleConverter$StringStore);
        dataOutputStream.writeShort(styleConverter$StringStore.addString(this.name));
        dataOutputStream.writeShort(this.styleClassSet.size());
        for (StyleClass styleClass : this.styleClassSet) {
            dataOutputStream.writeShort(styleConverter$StringStore.addString(styleClass.getStyleClassName()));
        }
        dataOutputStream.writeShort(styleConverter$StringStore.addString(this.id));
        int n2 = this.pseudoClassState.size() + (this.nodeOrientation == NodeOrientation.RIGHT_TO_LEFT || this.nodeOrientation == NodeOrientation.LEFT_TO_RIGHT ? 1 : 0);
        dataOutputStream.writeShort(n2);
        for (PseudoClass pseudoClass : this.pseudoClassState) {
            dataOutputStream.writeShort(styleConverter$StringStore.addString(pseudoClass.getPseudoClassName()));
        }
        if (this.nodeOrientation == NodeOrientation.RIGHT_TO_LEFT) {
            dataOutputStream.writeShort(styleConverter$StringStore.addString("dir(rtl)"));
            return;
        }
        if (this.nodeOrientation == NodeOrientation.LEFT_TO_RIGHT) {
            dataOutputStream.writeShort(styleConverter$StringStore.addString("dir(ltr)"));
        }
    }

    static SimpleSelector readBinary(int n2, DataInputStream dataInputStream, String[] stringArray) throws IOException {
        String string = stringArray[dataInputStream.readShort()];
        int n3 = dataInputStream.readShort();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < n3; ++i2) {
            arrayList.add(stringArray[dataInputStream.readShort()]);
        }
        String string2 = stringArray[dataInputStream.readShort()];
        n3 = dataInputStream.readShort();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i3 = 0; i3 < n3; ++i3) {
            arrayList2.add(stringArray[dataInputStream.readShort()]);
        }
        return new SimpleSelector(string, arrayList, arrayList2, string2);
    }
}

