/*
 * Decompiled with CFR 0.152.
 */
package javafx.css.converter;

import com.sun.javafx.util.Utils;
import java.util.Map;
import javafx.css.CssMetaData;
import javafx.css.ParsedValue;
import javafx.css.Size;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.converter.FontConverter$Holder;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public final class FontConverter
extends StyleConverter<ParsedValue[], Font> {
    public static StyleConverter<ParsedValue[], Font> getInstance() {
        return FontConverter$Holder.INSTANCE;
    }

    private FontConverter() {
    }

    @Override
    public final Font convert(ParsedValue<ParsedValue[], Font> object, Font font) {
        Object object2;
        Object object3;
        object = object.getValue();
        font = font != null ? font : Font.getDefault();
        String string = object[0] != null ? Utils.stripQuotes((String)object[0].convert(font)) : font.getFamily();
        double d2 = font.getSize();
        if (object[1] != null) {
            object3 = (ParsedValue)object[1].getValue();
            object2 = (Size)((ParsedValue)object3).convert(font);
            d2 = object2.pixels(font.getSize(), font);
        }
        object3 = object[2] != null ? (FontWeight)((Object)object[2].convert(font)) : FontWeight.NORMAL;
        object2 = object[3] != null ? (FontPosture)((Object)object[3].convert(font)) : FontPosture.REGULAR;
        object = Font.font(string, object3, (FontPosture)((Object)object2), d2);
        return object;
    }

    @Override
    public final Font convert(Map<CssMetaData<? extends Styleable, ?>, Object> object) {
        Object object2 = Font.getDefault();
        double d2 = ((Font)object2).getSize();
        object2 = ((Font)object2).getFamily();
        FontWeight fontWeight = FontWeight.NORMAL;
        FontPosture fontPosture = FontPosture.REGULAR;
        for (Map.Entry entry : object.entrySet()) {
            Object v2 = entry.getValue();
            if (v2 == null) continue;
            String string = ((CssMetaData)entry.getKey()).getProperty();
            if (string.endsWith("font-size")) {
                d2 = ((Number)v2).doubleValue();
                continue;
            }
            if (string.endsWith("font-family")) {
                object2 = Utils.stripQuotes((String)v2);
                continue;
            }
            if (string.endsWith("font-weight")) {
                fontWeight = (FontWeight)((Object)v2);
                continue;
            }
            if (!string.endsWith("font-style")) continue;
            fontPosture = (FontPosture)((Object)v2);
        }
        object = Font.font((String)object2, fontWeight, fontPosture, d2);
        return object;
    }

    public final String toString() {
        return "FontConverter";
    }
}

