/*
 * Decompiled with CFR 0.152.
 */
package javafx.css.converter;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.logging.PlatformLogger$Level;
import com.sun.javafx.util.DataURI;
import com.sun.javafx.util.Logging;
import com.sun.javafx.util.Utils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import javafx.application.Application;
import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.css.converter.StringConverter;
import javafx.css.converter.URLConverter$Holder;
import javafx.scene.text.Font;

public final class URLConverter
extends StyleConverter<ParsedValue[], String> {
    public static StyleConverter<ParsedValue[], String> getInstance() {
        return URLConverter$Holder.INSTANCE;
    }

    private URLConverter() {
    }

    @Override
    public final String convert(ParsedValue<ParsedValue[], String> object, Font object2) {
        Object object3 = null;
        object2 = ((ParsedValue[])(object = ((ParsedValue)object).getValue())).length > 0 ? StringConverter.getInstance().convert(object[0], (Font)object2) : null;
        if ((object2 = object2 != null ? ((String)object2).trim() : null) != null && !((String)object2).isEmpty()) {
            if (DataURI.matchScheme((String)(object2 = ((String)object2).startsWith("url(") ? Utils.stripQuotes(((String)object2).substring(4, ((String)object2).length() - 1)) : Utils.stripQuotes((String)object2)))) {
                object3 = object2;
            } else if (!((String)object2).isEmpty()) {
                object = ((ParsedValue[])object).length > 1 && object[1] != null ? (String)object[1].getValue() : null;
                if ((object = this.resolve((String)object, (String)object2)) != null) {
                    object3 = ((URL)object).toExternalForm();
                }
            }
        }
        return object3;
    }

    private URL resolve(String object, String object2) {
        try {
            object2 = new URI((String)object2);
            if (((URI)object2).isAbsolute()) {
                return ((URI)object2).toURL();
            }
            Object object3 = this.resolveRuntimeImport((URI)object2);
            if (object3 != null) {
                return object3;
            }
            object3 = ((URI)object2).getPath();
            if (((String)object3).startsWith("/")) {
                object = Thread.currentThread().getContextClassLoader();
                return ((ClassLoader)object).getResource(((String)object3).substring(1));
            }
            if ((object = object != null ? ((String)object).trim() : null) != null && !((String)object).isEmpty()) {
                if (!((URI)(object = new URI((String)object))).isOpaque()) {
                    object = ((URI)object).resolve((URI)object2);
                    return ((URI)object).toURL();
                }
                object = ((URI)object).toURL();
                return new URL((URL)object, ((URI)object2).getPath());
            }
            object = Thread.currentThread().getContextClassLoader();
            return ((ClassLoader)object).getResource((String)object3);
        }
        catch (MalformedURLException | URISyntaxException exception) {
            PlatformLogger platformLogger = Logging.getCSSLogger();
            if (platformLogger.isLoggable(PlatformLogger$Level.WARNING)) {
                platformLogger.warning(exception.getLocalizedMessage());
            }
            return null;
        }
    }

    private URL resolveRuntimeImport(URI object) {
        if ((((String)(object = ((String)(object = ((URI)object).getPath())).startsWith("/") ? ((String)object).substring(1) : object)).startsWith("com/sun/javafx/scene/control/skin/modena/") || ((String)object).startsWith("com/sun/javafx/scene/control/skin/caspian/")) && (((String)object).endsWith(".css") || ((String)object).endsWith(".bss"))) {
            System.err.println("WARNING: resolveRuntimeImport cannot resolve: " + (String)object);
            Object object2 = System.getSecurityManager();
            if (object2 == null) {
                object2 = Thread.currentThread().getContextClassLoader();
                object2 = ((ClassLoader)object2).getResource((String)object);
                return object2;
            }
            try {
                object2 = AccessController.doPrivileged(() -> {
                    Object object = Application.class.getProtectionDomain();
                    object = ((ProtectionDomain)object).getCodeSource();
                    return ((CodeSource)object).getLocation();
                });
                object2 = ((URL)object2).toURI();
                String string = ((URI)object2).getScheme();
                String string2 = ((URI)object2).getPath();
                if ("file".equals(string) && string2.endsWith(".jar") && "file".equals(string)) {
                    string = "jar:file";
                    string2 = string2.concat("!/");
                }
                string2 = string2.concat((String)object);
                object = ((URI)object2).getUserInfo();
                String string3 = ((URI)object2).getHost();
                int n2 = ((URI)object2).getPort();
                object = new URI(string, (String)object, string3, n2, string2, null, null);
                return ((URI)object).toURL();
            }
            catch (MalformedURLException | URISyntaxException | PrivilegedActionException exception) {}
        }
        return null;
    }

    public final String toString() {
        return "URLType";
    }
}

