/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import com.sun.glass.ui.Screen;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.application.PlatformImpl$FinishListener;
import com.sun.javafx.embed.EmbeddedSceneInterface;
import com.sun.javafx.embed.EmbeddedStageInterface;
import com.sun.javafx.embed.swing.SwingDnD;
import com.sun.javafx.embed.swing.SwingEvents;
import com.sun.javafx.embed.swing.SwingNodeHelper;
import com.sun.javafx.embed.swing.newimpl.JFXPanelInteropN;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.stage.EmbeddedWindow;
import com.sun.javafx.tk.Toolkit;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SecondaryLoop;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.Serializable;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;
import javafx.embed.swing.InputMethodSupport;
import javafx.embed.swing.InputMethodSupport$InputMethodRequestsAdapter;
import javafx.embed.swing.JFXPanel$1;
import javafx.embed.swing.JFXPanel$HostContainer;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Point2D;
import javafx.scene.Scene;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class JFXPanel
extends JComponent {
    private static final PlatformLogger log = PlatformLogger.getLogger(JFXPanel.class.getName());
    private static AtomicInteger instanceCount = new AtomicInteger(0);
    private static PlatformImpl$FinishListener finishListener;
    private transient JFXPanel$HostContainer hostContainer;
    private volatile transient EmbeddedWindow stage;
    private volatile transient Scene scene;
    private transient SwingDnD dnd;
    private transient EmbeddedStageInterface stagePeer;
    private transient EmbeddedSceneInterface scenePeer;
    private int pWidth;
    private int pHeight;
    private double scaleFactorX = 1.0;
    private double scaleFactorY = 1.0;
    private volatile int pPreferredWidth = -1;
    private volatile int pPreferredHeight = -1;
    private volatile int screenX = 0;
    private volatile int screenY = 0;
    private BufferedImage pixelsIm;
    private volatile float opacity = 1.0f;
    private AtomicInteger disableCount = new AtomicInteger(0);
    private boolean isCapturingMouse = false;
    private static boolean fxInitialized;
    private JFXPanelInteropN jfxPanelIOP;
    private transient AWTEventListener ungrabListener = serializable -> {
        if (this.jfxPanelIOP.isUngrabEvent(serializable)) {
            SwingNodeHelper.runOnFxThread(() -> {
                if (this.stagePeer != null && this.getScene() != null && this.getScene().getFocusOwner() != null && this.getScene().getFocusOwner().isFocused()) {
                    this.stagePeer.focusUngrab();
                }
            });
        }
        if (serializable instanceof MouseEvent && serializable.getID() == 501 && serializable.getSource() instanceof Component) {
            Window window = SwingUtilities.getWindowAncestor(this);
            Serializable serializable2 = serializable = (serializable = (Component)serializable.getSource()) instanceof Window ? (Window)((Object)serializable) : SwingUtilities.getWindowAncestor((Component)((Object)serializable));
            if (window == serializable) {
                SwingNodeHelper.runOnFxThread(() -> {
                    if (this.stagePeer != null) {
                        this.stagePeer.focusUngrab();
                    }
                });
            }
        }
    };

    private synchronized void registerFinishListener() {
        if (instanceCount.getAndIncrement() > 0) {
            return;
        }
        finishListener = new JFXPanel$1(this);
        PlatformImpl.addListener(finishListener);
    }

    private synchronized void deregisterFinishListener() {
        if (instanceCount.decrementAndGet() > 0) {
            return;
        }
        PlatformImpl.removeListener(finishListener);
        finishListener = null;
    }

    private static synchronized void initFx() {
        if (fxInitialized) {
            return;
        }
        Object object = AccessController.doPrivileged(java.awt.Toolkit.getDefaultToolkit()::getSystemEventQueue);
        if (EventQueue.isDispatchThread()) {
            object = ((EventQueue)object).createSecondaryLoop();
            Throwable[] throwableArray = new Throwable[]{null};
            new Thread(() -> JFXPanel.lambda$initFx$1(throwableArray, (SecondaryLoop)object)).start();
            object.enter();
            if (throwableArray[0] != null) {
                if (throwableArray[0] instanceof RuntimeException) {
                    throw (RuntimeException)throwableArray[0];
                }
                if (throwableArray[0] instanceof Error) {
                    throw (Error)throwableArray[0];
                }
                throw new RuntimeException("FX initialization failed", throwableArray[0]);
            }
        } else {
            PlatformImpl.startup(() -> {});
        }
        fxInitialized = true;
    }

    public JFXPanel() {
        this.jfxPanelIOP = new JFXPanelInteropN();
        JFXPanel.initFx();
        this.hostContainer = new JFXPanel$HostContainer(this);
        this.enableEvents(231485L);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
    }

    public Scene getScene() {
        return this.scene;
    }

    public void setScene(Scene scene) {
        if (Toolkit.getToolkit().isFxUserThread()) {
            this.setSceneImpl(scene);
            return;
        }
        Object object = AccessController.doPrivileged(java.awt.Toolkit.getDefaultToolkit()::getSystemEventQueue);
        object = ((EventQueue)object).createSecondaryLoop();
        Platform.runLater(() -> this.lambda$setScene$3(scene, (SecondaryLoop)object));
        object.enter();
    }

    private void setSceneImpl(Scene scene) {
        if (this.stage != null && scene == null) {
            this.stage.hide();
            this.stage = null;
        }
        this.scene = scene;
        if (this.stage == null && scene != null) {
            this.stage = new EmbeddedWindow(this.hostContainer);
        }
        if (this.stage != null) {
            this.stage.setScene(scene);
            if (!this.stage.isShowing()) {
                this.stage.show();
            }
        }
    }

    @Override
    public final void setOpaque(boolean bl2) {
        if (!bl2) {
            super.setOpaque(bl2);
        }
    }

    @Override
    public final boolean isOpaque() {
        return false;
    }

    private Screen findScreen(GraphicsConfiguration object) {
        Rectangle rectangle = ((GraphicsConfiguration)object).getBounds();
        object = ((GraphicsConfiguration)object).getDefaultTransform();
        for (Screen screen : Screen.getScreens()) {
            Screen screen2;
            if (!(Math.abs((double)screen2.getPlatformX() - rectangle.getX()) < 2.0) || !(Math.abs((double)screen.getPlatformY() - rectangle.getY()) < 2.0) || !(Math.abs((double)screen.getPlatformWidth() - ((AffineTransform)object).getScaleX() * rectangle.getWidth()) < 2.0) || !(Math.abs((double)screen.getPlatformHeight() - ((AffineTransform)object).getScaleY() * rectangle.getHeight()) < 2.0)) continue;
            return screen;
        }
        return null;
    }

    private Point2D convertSwingToFxPixel(GraphicsConfiguration object, double d2, double d3) {
        double d4;
        double d5;
        if ((object = this.findScreen((GraphicsConfiguration)object)) != null) {
            AffineTransform affineTransform = this.getGraphicsConfiguration().getDefaultTransform();
            float f2 = ((Screen)object).getPlatformScaleX();
            float f3 = ((Screen)object).getPlatformScaleY();
            int n2 = ((Screen)object).getX();
            int n3 = ((Screen)object).getY();
            double d6 = affineTransform.getScaleX();
            double d7 = affineTransform.getScaleY();
            int n4 = ((Screen)object).getPlatformX();
            int n5 = ((Screen)object).getPlatformY();
            d5 = (double)n2 + (d2 - (double)n4) * d6 / (double)f2;
            d4 = (double)n3 + (d3 - (double)n5) * d7 / (double)f3;
        } else {
            d5 = d2;
            d4 = d3;
        }
        return new Point2D(d5, d4);
    }

    private void sendMouseEventToFX(MouseEvent mouseEvent) {
        boolean bl2;
        if (this.scenePeer == null || !this.isFxEnabled()) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: 
            case 502: 
            case 506: {
                if (mouseEvent.getButton() <= 5) break;
                return;
            }
        }
        int n2 = mouseEvent.getModifiersEx();
        boolean bl3 = (n2 & 0x400) != 0;
        boolean bl4 = (n2 & 0x800) != 0;
        boolean bl5 = (n2 & 0x1000) != 0;
        boolean bl6 = (n2 & MouseEvent.getMaskForButton(4)) != 0;
        boolean bl7 = bl2 = (n2 & MouseEvent.getMaskForButton(5)) != 0;
        if (mouseEvent.getID() == 506) {
            if (!this.isCapturingMouse) {
                return;
            }
        } else if (mouseEvent.getID() == 501) {
            this.isCapturingMouse = true;
        } else if (mouseEvent.getID() == 502) {
            if (!this.isCapturingMouse) {
                return;
            }
            this.isCapturingMouse = bl3 || bl4 || bl5 || bl6 || bl2;
        } else if (mouseEvent.getID() == 500) {
            return;
        }
        boolean bl8 = false;
        if (mouseEvent.getID() == 501 || mouseEvent.getID() == 502) {
            bl8 = mouseEvent.isPopupTrigger();
        }
        JFXPanel jFXPanel = this;
        Point2D point2D = jFXPanel.convertSwingToFxPixel(jFXPanel.getGraphicsConfiguration(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen());
        int n3 = (int)Math.round(point2D.getX());
        int n4 = (int)Math.round(point2D.getY());
        if (mouseEvent.getID() == 507) {
            this.scenePeer.scrollEvent(7, 0.0, -SwingEvents.getWheelRotation(mouseEvent), 0.0, 0.0, 40.0, 40.0, mouseEvent.getX(), mouseEvent.getY(), n3, n4, (n2 & 0x40) != 0, (n2 & 0x80) != 0, (n2 & 0x200) != 0, (n2 & 0x100) != 0, false);
        } else {
            this.scenePeer.mouseEvent(SwingEvents.mouseIDToEmbedMouseType(mouseEvent.getID()), SwingEvents.mouseButtonToEmbedMouseButton(mouseEvent.getButton(), n2), bl3, bl4, bl5, bl6, bl2, mouseEvent.getX(), mouseEvent.getY(), n3, n4, (n2 & 0x40) != 0, (n2 & 0x80) != 0, (n2 & 0x200) != 0, (n2 & 0x100) != 0, bl8);
        }
        if (mouseEvent.isPopupTrigger()) {
            this.scenePeer.menuEvent(mouseEvent.getX(), mouseEvent.getY(), n3, n4, false);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501 && mouseEvent.getButton() == 1 && this.isFocusable() && !this.hasFocus()) {
            this.requestFocus();
            if (this.stagePeer != null) {
                this.stagePeer.setFocused(true, 0);
            }
        }
        this.sendMouseEventToFX(mouseEvent);
        super.processMouseEvent(mouseEvent);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        this.sendMouseEventToFX(mouseEvent);
        super.processMouseMotionEvent(mouseEvent);
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        this.sendMouseEventToFX(mouseWheelEvent);
        super.processMouseWheelEvent(mouseWheelEvent);
    }

    private void sendKeyEventToFX(KeyEvent keyEvent) {
        char[] cArray;
        if (this.scenePeer == null || !this.isFxEnabled()) {
            return;
        }
        if (keyEvent.getKeyChar() == '\uffff') {
            cArray = new char[]{};
        } else {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = SwingEvents.keyCharToEmbedKeyChar(keyEvent.getKeyChar());
        }
        char[] cArray3 = cArray;
        this.scenePeer.keyEvent(SwingEvents.keyIDToEmbedKeyType(keyEvent.getID()), keyEvent.getKeyCode(), cArray3, SwingEvents.keyModifiersToEmbedKeyModifiers(keyEvent.getModifiersEx()));
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        this.sendKeyEventToFX(keyEvent);
        super.processKeyEvent(keyEvent);
    }

    private void sendResizeEventToFX() {
        if (this.stagePeer != null) {
            this.stagePeer.setSize(this.pWidth, this.pHeight);
        }
        if (this.scenePeer != null) {
            this.scenePeer.setSize(this.pWidth, this.pHeight);
        }
    }

    @Override
    protected void processComponentEvent(ComponentEvent componentEvent) {
        switch (componentEvent.getID()) {
            case 101: {
                this.updateComponentSize();
                break;
            }
            case 100: {
                if (!this.updateScreenLocation()) break;
                this.sendMoveEventToFX();
            }
        }
        super.processComponentEvent(componentEvent);
    }

    private void updateComponentSize() {
        int n2 = this.pWidth;
        int n3 = this.pHeight;
        if (this.getBorder() != null) {
            Insets insets = this.getBorder().getBorderInsets(this);
            this.pWidth -= insets.left + insets.right;
            this.pHeight -= insets.top + insets.bottom;
        }
        this.pWidth = Math.max(0, this.getWidth());
        this.pHeight = Math.max(0, this.getHeight());
        this.getGraphics();
        double d2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform().getScaleX();
        double d3 = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform().getScaleY();
        if (n2 == 0 && n3 == 0 && this.pWidth == 0 && this.pHeight == 0) {
            return;
        }
        if (n2 != this.pWidth || n3 != this.pHeight || d2 != this.scaleFactorX || d3 != this.scaleFactorY) {
            this.createResizePixelBuffer(d2, d3);
            if (this.scenePeer != null) {
                this.scenePeer.setPixelScaleFactors((float)d2, (float)d3);
            }
            this.scaleFactorX = d2;
            this.scaleFactorY = d3;
            this.sendResizeEventToFX();
        }
    }

    private boolean updateScreenLocation() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.isShowing()) {
                Object object2 = this.getLocationOnScreen();
                JFXPanel jFXPanel = this;
                object2 = jFXPanel.convertSwingToFxPixel(jFXPanel.getGraphicsConfiguration(), ((Point)object2).x, ((Point)object2).y);
                this.screenX = (int)Math.round(((Point2D)object2).getX());
                this.screenY = (int)Math.round(((Point2D)object2).getY());
                return true;
            }
        }
        return false;
    }

    private void sendMoveEventToFX() {
        if (this.stagePeer == null) {
            return;
        }
        this.stagePeer.setLocation(this.screenX, this.screenY);
    }

    @Override
    protected void processHierarchyBoundsEvent(HierarchyEvent hierarchyEvent) {
        if (hierarchyEvent.getID() == 1401 && this.updateScreenLocation()) {
            this.sendMoveEventToFX();
        }
        super.processHierarchyBoundsEvent(hierarchyEvent);
    }

    @Override
    protected void processHierarchyEvent(HierarchyEvent hierarchyEvent) {
        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && this.updateScreenLocation()) {
            this.sendMoveEventToFX();
        }
        super.processHierarchyEvent(hierarchyEvent);
    }

    private void sendFocusEventToFX(FocusEvent focusEvent) {
        int n2;
        if (this.stage == null || this.stagePeer == null || !this.isFxEnabled()) {
            return;
        }
        boolean bl2 = focusEvent.getID() == 1004;
        int n3 = n2 = bl2 ? 0 : 3;
        if (bl2) {
            if (focusEvent.getCause() == FocusEvent.Cause.TRAVERSAL_FORWARD) {
                n2 = 1;
            } else if (focusEvent.getCause() == FocusEvent.Cause.TRAVERSAL_BACKWARD) {
                n2 = 2;
            }
        }
        this.stagePeer.setFocused(bl2, n2);
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        this.sendFocusEventToFX(focusEvent);
        super.processFocusEvent(focusEvent);
    }

    private void createResizePixelBuffer(double d2, double d3) {
        if (this.scenePeer == null || this.pWidth <= 0 || this.pHeight <= 0) {
            this.pixelsIm = null;
            return;
        }
        BufferedImage bufferedImage = this.pixelsIm;
        int n2 = (int)Math.ceil((double)this.pWidth * d2);
        int n3 = (int)Math.ceil((double)this.pHeight * d3);
        this.pixelsIm = new BufferedImage(n2, n3, SwingFXUtils.getBestBufferedImageType(this.scenePeer.getPixelFormat(), null, false));
        if (bufferedImage != null) {
            double d4 = d2 / this.scaleFactorX;
            double d5 = d3 / this.scaleFactorY;
            int n4 = (int)Math.ceil((double)bufferedImage.getWidth() * d4);
            int n5 = (int)Math.ceil((double)bufferedImage.getHeight() * d5);
            Graphics graphics = this.pixelsIm.getGraphics();
            try {
                graphics.drawImage(bufferedImage, 0, 0, n4, n5, null);
                return;
            }
            finally {
                graphics.dispose();
            }
        }
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        if (inputMethodEvent.getID() == 1100) {
            this.sendInputMethodEventToFX(inputMethodEvent);
        }
        super.processInputMethodEvent(inputMethodEvent);
    }

    private void sendInputMethodEventToFX(InputMethodEvent inputMethodEvent) {
        String string = InputMethodSupport.getTextForEvent(inputMethodEvent);
        int n2 = 0;
        if (inputMethodEvent.getCaret() != null) {
            n2 = inputMethodEvent.getCaret().getInsertionIndex();
        }
        this.scenePeer.inputMethodEvent(javafx.scene.input.InputMethodEvent.INPUT_METHOD_TEXT_CHANGED, InputMethodSupport.inputMethodEventComposed(string, inputMethodEvent.getCommittedCharacterCount()), string.substring(0, inputMethodEvent.getCommittedCharacterCount()), n2);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        block12: {
            if (this.scenePeer == null) {
                return;
            }
            if (this.pixelsIm == null) {
                JFXPanel jFXPanel = this;
                jFXPanel.createResizePixelBuffer(jFXPanel.scaleFactorX, this.scaleFactorY);
                if (this.pixelsIm == null) {
                    return;
                }
            }
            Object object = (DataBufferInt)this.pixelsIm.getRaster().getDataBuffer();
            int[] nArray = ((DataBufferInt)object).getData();
            object = nArray;
            object = IntBuffer.wrap(nArray);
            this.scenePeer.getPixels((IntBuffer)object, this.pWidth, this.pHeight);
            object = null;
            try {
                Object object2;
                object = graphics.create();
                if (this.opacity < 1.0f && object instanceof Graphics2D) {
                    object2 = (Graphics2D)object;
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.opacity);
                    ((Graphics2D)object2).setComposite(alphaComposite);
                }
                if (this.getBorder() != null) {
                    object2 = this.getBorder().getBorderInsets(this);
                    ((Graphics)object).translate(((Insets)object2).left, ((Insets)object2).top);
                }
                ((Graphics)object).drawImage(this.pixelsIm, 0, 0, this.pWidth, this.pHeight, null);
                double d2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform().getScaleX();
                double d3 = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform().getScaleY();
                if (this.scaleFactorX != d2 || this.scaleFactorY != d3) {
                    this.createResizePixelBuffer(d2, d3);
                    this.scenePeer.setPixelScaleFactors((float)d2, (float)d3);
                    this.scaleFactorX = d2;
                    this.scaleFactorY = d3;
                }
                if (object != null) {
                    ((Graphics)object).dispose();
                    return;
                }
            }
            catch (Throwable throwable) {
                try {
                    Throwable throwable2 = throwable;
                    throwable.printStackTrace();
                    return;
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    if (object == null) break block12;
                    ((Graphics)object).dispose();
                }
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet() || this.scenePeer == null) {
            return super.getPreferredSize();
        }
        return new Dimension(this.pPreferredWidth, this.pPreferredHeight);
    }

    private boolean isFxEnabled() {
        return this.disableCount.get() == 0;
    }

    private void setFxEnabled(boolean bl2) {
        if (!bl2) {
            if (this.disableCount.incrementAndGet() == 1 && this.dnd != null) {
                this.dnd.removeNotify();
                return;
            }
        } else {
            if (this.disableCount.get() == 0) {
                return;
            }
            if (this.disableCount.decrementAndGet() == 0 && this.dnd != null) {
                this.dnd.addNotify();
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.registerFinishListener();
        AccessController.doPrivileged(() -> {
            this.getToolkit().addAWTEventListener(this.ungrabListener, this.jfxPanelIOP.getMask());
            return null;
        });
        this.updateComponentSize();
        SwingNodeHelper.runOnFxThread(() -> {
            if (this.stage != null && !this.stage.isShowing()) {
                this.stage.show();
                this.sendMoveEventToFX();
            }
        });
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        EmbeddedSceneInterface embeddedSceneInterface = this.scenePeer;
        if (embeddedSceneInterface == null) {
            return null;
        }
        return new InputMethodSupport$InputMethodRequestsAdapter(embeddedSceneInterface.getInputMethodRequests());
    }

    @Override
    public void removeNotify() {
        SwingNodeHelper.runOnFxThread(() -> {
            if (this.stage != null && this.stage.isShowing()) {
                this.stage.hide();
            }
        });
        this.pixelsIm = null;
        this.pWidth = 0;
        this.pHeight = 0;
        super.removeNotify();
        AccessController.doPrivileged(() -> {
            this.getToolkit().removeAWTEventListener(this.ungrabListener);
            return null;
        });
        this.getInputContext().removeNotify(this);
        this.deregisterFinishListener();
    }

    private void invokeOnClientEDT(Runnable runnable) {
        this.jfxPanelIOP.postEvent(this, new InvocationEvent((Object)this, runnable));
    }

    final BufferedImage test_getPixelsIm() {
        return this.pixelsIm;
    }

    private /* synthetic */ void lambda$setScene$3(Scene scene, SecondaryLoop secondaryLoop) {
        try {
            this.setSceneImpl(scene);
            return;
        }
        finally {
            secondaryLoop.exit();
        }
    }

    private static /* synthetic */ void lambda$initFx$1(Throwable[] throwableArray, SecondaryLoop secondaryLoop) {
        try {
            PlatformImpl.startup(() -> {});
            return;
        }
        catch (Throwable throwable) {
            throwableArray[0] = throwable;
            return;
        }
        finally {
            secondaryLoop.exit();
        }
    }
}

